"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardInitializer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ContactCardInitializer extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, "Create a new greeting card")), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: "First name"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "popfirst",
      value: this.state.firstName,
      onChange: e => this.setState({
        firstName: e.target.value
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: "Last name"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "popfirst",
      value: this.state.lastName,
      placeholder: "optional",
      onChange: e => this.setState({
        lastName: e.target.value
      })
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.onCancel
    }, "Cancel"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: !this.state.firstName,
      onClick: () => {
        if (this.state.firstName) {
          this.props.onCreate({
            firstName: this.state.firstName,
            ...(this.state.lastName ? {
              lastName: this.state.lastName
            } : {})
          });
        }
      },
      fill: true
    }, "Create")));
  }
}
exports.ContactCardInitializer = ContactCardInitializer;