"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMMON_EMBEDDABLE_GROUPING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const COMMON_EMBEDDABLE_GROUPING = exports.COMMON_EMBEDDABLE_GROUPING = {
  legacy: {
    id: 'legacy',
    getDisplayName: () => _i18n.i18n.translate('embeddableApi.common.constants.grouping.legacy', {
      defaultMessage: 'Legacy'
    }),
    order: -2
  },
  annotation: {
    id: 'annotation-and-navigation',
    getDisplayName: () => _i18n.i18n.translate('embeddableApi.common.constants.grouping.annotations', {
      defaultMessage: 'Annotations and Navigation'
    })
  },
  other: {
    id: 'other',
    getDisplayName: () => _i18n.i18n.translate('embeddableApi.common.constants.grouping.other', {
      defaultMessage: 'Other'
    }),
    getIconType: () => 'empty',
    order: -1
  }
};