"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReactEmbeddableSavedObject = exports.getReactEmbeddableSavedObjects = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registry = new Map();
const registerReactEmbeddableSavedObject = ({
  onAdd,
  embeddableType,
  savedObjectType,
  savedObjectName,
  getIconForSavedObject,
  getSavedObjectSubType,
  getTooltipForSavedObject
}) => {
  if (registry.has(embeddableType)) {
    throw new Error(_i18n.i18n.translate('embeddableApi.embeddableSavedObjectRegistry.keyAlreadyExistsError', {
      defaultMessage: `Embeddable type {embeddableType} already exists in the registry.`,
      values: {
        embeddableType
      }
    }));
  }
  registry.set(embeddableType, {
    onAdd,
    savedObjectMetaData: {
      name: savedObjectName,
      type: savedObjectType,
      getIconForSavedObject,
      getTooltipForSavedObject,
      getSavedObjectSubType
    }
  });
};
exports.registerReactEmbeddableSavedObject = registerReactEmbeddableSavedObject;
const getReactEmbeddableSavedObjects = () => {
  return registry.entries();
};
exports.getReactEmbeddableSavedObjects = getReactEmbeddableSavedObjects;