"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAddPanelFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const LazyAddPanelFlyout = /*#__PURE__*/_react.default.lazy(async () => {
  const module = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_flyout')));
  return {
    default: module.AddPanelFlyout
  };
});
const openAddPanelFlyout = ({
  container,
  onAddPanel,
  onClose
}) => {
  // send the overlay ref to the root embeddable if it is capable of tracking overlays
  const flyoutSession = _kibana_services.core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(LazyAddPanelFlyout, {
    container: container,
    onAddPanel: onAddPanel
  })), _kibana_services.core), {
    'data-test-subj': 'dashboardAddPanel',
    ownFocus: true,
    onClose: overlayRef => {
      if (onClose) onClose();
      overlayRef.close();
    }
  });
  return flyoutSession;
};
exports.openAddPanelFlyout = openAddPanelFlyout;