"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConversationRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConversationRoute = router => {
  router.versioned.delete({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.DeleteConversationRequestParams)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      const {
        id
      } = request.params;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const license = ctx.licensing.license;
      if (!(0, _helpers.hasAIAssistantLicense)(license)) {
        return response.forbidden({
          body: {
            message: _helpers.UPGRADE_LICENSE_MESSAGE
          }
        });
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const authenticatedUser = ctx.elasticAssistant.getCurrentUser();
      if (authenticatedUser == null) {
        return assistantResponse.error({
          body: `Authenticated user not found`,
          statusCode: 401
        });
      }
      const existingConversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getConversation({
        id,
        authenticatedUser
      }));
      if (existingConversation == null) {
        return assistantResponse.error({
          body: `conversation id: "${id}" not found`,
          statusCode: 404
        });
      }
      await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.deleteConversation(id));
      return response.ok({
        body: {}
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteConversationRoute = deleteConversationRoute;