"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendConversationMessageRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appendConversationMessageRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.AppendConversationMessageRequestBody),
        params: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.AppendConversationMessageRequestParams)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    const {
      id
    } = request.params;
    try {
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const license = ctx.licensing.license;
      if (!(0, _helpers.hasAIAssistantLicense)(license)) {
        return response.forbidden({
          body: {
            message: _helpers.UPGRADE_LICENSE_MESSAGE
          }
        });
      }
      const dataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const authenticatedUser = ctx.elasticAssistant.getCurrentUser();
      if (authenticatedUser == null) {
        return assistantResponse.error({
          body: `Authenticated user not found`,
          statusCode: 401
        });
      }
      const existingConversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getConversation({
        id,
        authenticatedUser
      }));
      if (existingConversation == null) {
        return assistantResponse.error({
          body: `conversation id: "${id}" not found`,
          statusCode: 404
        });
      }
      const conversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.appendConversationMessages({
        existingConversation,
        messages: request.body.messages
      }));
      if (conversation == null) {
        return assistantResponse.error({
          body: `conversation id: "${id}" was not updated with appended message`,
          statusCode: 400
        });
      }
      return response.ok({
        body: conversation
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.appendConversationMessageRoute = appendConversationMessageRoute;