"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createKnowledgeBaseEntryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _common_attributes = require("@kbn/elastic-assistant-common/impl/schemas/knowledge_base/common_attributes.gen");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKnowledgeBaseEntryRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_common_attributes.KnowledgeBaseEntryCreateProps)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const logger = ctx.elasticAssistant.logger;

      // Perform license, authenticated user and FF checks
      const checkResponse = (0, _helpers.performChecks)({
        authenticatedUser: true,
        capability: 'assistantKnowledgeBaseByDefault',
        context: ctx,
        license: true,
        request,
        response
      });
      if (checkResponse) {
        return checkResponse;
      }
      logger.debug(`Creating KB Entry:\n${JSON.stringify(request.body)}`);
      const documents = [{
        metadata: request.body.metadata,
        pageContent: request.body.text
      }];
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const createResponse = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.addKnowledgeBaseDocuments({
        documents
      }));
      if (createResponse == null) {
        return assistantResponse.error({
          body: `Knowledge Base Entry was not created`,
          statusCode: 400
        });
      }
      return response.ok({
        body: _common_attributes.KnowledgeBaseEntryResponse.parse(createResponse[0])
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.createKnowledgeBaseEntryRoute = createKnowledgeBaseEntryRoute;