"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkActionKnowledgeBaseEntriesRoute = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _helpers = require("../../helpers");
var _constants = require("../../../../common/constants");
var _utils = require("../../utils");
var _transforms = require("../../../ai_assistant_data_clients/knowledge_base/transforms");
var _create_knowledge_base_entry = require("../../../ai_assistant_data_clients/knowledge_base/create_knowledge_base_entry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildBulkResponse = (response, {
  errors = [],
  updated = [],
  created = [],
  deleted = [],
  skipped = []
}) => {
  const numSucceeded = updated.length + created.length + deleted.length;
  const numSkipped = skipped.length;
  const numFailed = errors.length;
  const summary = {
    failed: numFailed,
    succeeded: numSucceeded,
    skipped: numSkipped,
    total: numSucceeded + numFailed + numSkipped
  };
  const results = {
    updated,
    created,
    deleted,
    skipped
  };
  if (numFailed > 0) {
    return response.custom({
      headers: {
        'content-type': 'application/json'
      },
      body: {
        message: summary.succeeded > 0 ? 'Bulk edit partially failed' : 'Bulk edit failed',
        attributes: {
          errors: errors.map(e => {
            var _e$status;
            return {
              statusCode: (_e$status = e.status) !== null && _e$status !== void 0 ? _e$status : 500,
              knowledgeBaseEntries: [{
                id: e.document.id,
                name: ''
              }],
              message: e.message
            };
          }),
          results,
          summary
        }
      },
      statusCode: 500
    });
  }
  const responseBody = {
    success: true,
    knowledgeBaseEntriesCount: summary.total,
    attributes: {
      results,
      summary
    }
  };
  return response.ok({
    body: responseBody
  });
};
const bulkActionKnowledgeBaseEntriesRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION,
    options: {
      tags: ['access:elasticAssistant'],
      timeout: {
        idleSocket: _moment.default.duration(15, 'minutes').asMilliseconds()
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.PerformKnowledgeBaseEntryBulkActionRequestBody)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _body$update, _body$create, _body$delete$ids$leng, _body$delete, _body$delete$ids, _body$create2, _body$delete2;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      const logger = ctx.elasticAssistant.logger;

      // Perform license, authenticated user and FF checks
      const checkResponse = (0, _helpers.performChecks)({
        authenticatedUser: true,
        capability: 'assistantKnowledgeBaseByDefault',
        context: ctx,
        license: true,
        request,
        response
      });
      if (checkResponse) {
        return checkResponse;
      }
      logger.debug(`Performing bulk action on Knowledge Base Entries:\n${JSON.stringify(request.body)}`);
      const {
        body
      } = request;
      const operationsCount = (body !== null && body !== void 0 && body.update ? (_body$update = body.update) === null || _body$update === void 0 ? void 0 : _body$update.length : 0) + (body !== null && body !== void 0 && body.create ? (_body$create = body.create) === null || _body$create === void 0 ? void 0 : _body$create.length : 0) + (body !== null && body !== void 0 && body.delete ? (_body$delete$ids$leng = (_body$delete = body.delete) === null || _body$delete === void 0 ? void 0 : (_body$delete$ids = _body$delete.ids) === null || _body$delete$ids === void 0 ? void 0 : _body$delete$ids.length) !== null && _body$delete$ids$leng !== void 0 ? _body$delete$ids$leng : 0 : 0);
      if (operationsCount > _constants.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE) {
        return assistantResponse.error({
          body: `More than ${_constants.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE} ids sent for bulk edit action.`,
          statusCode: 400
        });
      }
      const abortController = new AbortController();

      // subscribing to completed$, because it handles both cases when request was completed and aborted.
      // when route is finished by timeout, aborted$ is not getting fired
      request.events.completed$.subscribe(() => abortController.abort());
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const spaceId = ctx.elasticAssistant.getSpaceId();
      // Authenticated user null check completed in `performChecks()` above
      const authenticatedUser = ctx.elasticAssistant.getCurrentUser();
      if (body.create && body.create.length > 0) {
        const result = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.findDocuments({
          perPage: 100,
          page: 1,
          filter: `users:{ id: "${authenticatedUser === null || authenticatedUser === void 0 ? void 0 : authenticatedUser.profile_uid}" }`,
          fields: []
        }));
        if ((result === null || result === void 0 ? void 0 : result.data) != null && result.total > 0) {
          return assistantResponse.error({
            statusCode: 409,
            body: `Knowledge Base Entry id's: "${(0, _transforms.transformESSearchToKnowledgeBaseEntry)(result.data).map(c => c.id).join(',')}" already exists`
          });
        }
      }
      const writer = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.getWriter());
      const changedAt = new Date().toISOString();
      const {
        errors,
        docs_created: docsCreated,
        docs_updated: docsUpdated,
        docs_deleted: docsDeleted
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      } = await writer.bulk({
        documentsToCreate: (_body$create2 = body.create) === null || _body$create2 === void 0 ? void 0 : _body$create2.map(c => (0, _create_knowledge_base_entry.transformToCreateSchema)(changedAt, spaceId, authenticatedUser, c)),
        documentsToDelete: (_body$delete2 = body.delete) === null || _body$delete2 === void 0 ? void 0 : _body$delete2.ids,
        documentsToUpdate: [],
        // TODO: Support bulk update
        authenticatedUser
      });
      const created = docsCreated.length > 0 ? await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.findDocuments({
        page: 1,
        perPage: 100,
        filter: docsCreated.map(c => `_id:${c}`).join(' OR ')
      })) : undefined;
      return buildBulkResponse(response, {
        // @ts-ignore-next-line TS2322
        updated: docsUpdated,
        created: created !== null && created !== void 0 && created.data ? (0, _transforms.transformESSearchToKnowledgeBaseEntry)(created === null || created === void 0 ? void 0 : created.data) : [],
        deleted: docsDeleted !== null && docsDeleted !== void 0 ? docsDeleted : [],
        errors
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.bulkActionKnowledgeBaseEntriesRoute = bulkActionKnowledgeBaseEntriesRoute;