"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEvaluateRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _build_response = require("../../lib/build_response");
var _constants = require("../../../common/constants");
var _helpers = require("../helpers");
var _executors = require("../../lib/langchain/executors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEvaluateRoute = router => {
  router.versioned.get({
    access: _elasticAssistantCommon.INTERNAL_API_ACCESS,
    path: _constants.EVALUATE,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      response: {
        200: {
          body: {
            custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.GetEvaluateResponse)
          }
        }
      }
    }
  }, async (context, request, response) => {
    const assistantContext = await context.elasticAssistant;
    const logger = assistantContext.logger;

    // Validate evaluation feature is enabled
    const pluginName = (0, _helpers.getPluginNameFromRequest)({
      request,
      defaultPluginName: _helpers.DEFAULT_PLUGIN_NAME,
      logger
    });
    const registeredFeatures = assistantContext.getRegisteredFeatures(pluginName);
    if (!registeredFeatures.assistantModelEvaluation) {
      return response.notFound();
    }
    try {
      return response.ok({
        body: {
          agentExecutors: Object.keys(_executors.AGENT_EXECUTOR_MAP)
        }
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      const resp = (0, _build_response.buildResponse)(response);
      return resp.error({
        body: {
          error: error.message
        },
        statusCode: error.statusCode
      });
    }
  });
};
exports.getEvaluateRoute = getEvaluateRoute;