"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldContinueGetConversation = exports.shouldContinueGenerateTitle = exports.shouldContinue = void 0;
var _helpers = require("../../../../../routes/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Node to determine which conditional edge to choose. Essentially the 'router' node.
 *
 * @param logger - The scoped logger
 * @param state - The current state of the graph
 */
const shouldContinue = ({
  logger,
  state
}) => {
  logger.debug(`Node state:\n${JSON.stringify(state, null, 2)}`);
  if (state.agentOutcome && 'returnValues' in state.agentOutcome) {
    return 'end';
  }
  return 'continue';
};
exports.shouldContinue = shouldContinue;
const shouldContinueGenerateTitle = ({
  logger,
  state
}) => {
  var _state$conversation, _state$conversation$t, _state$conversation2;
  logger.debug(`Node state:\n${JSON.stringify(state, null, 2)}`);
  if ((_state$conversation = state.conversation) !== null && _state$conversation !== void 0 && (_state$conversation$t = _state$conversation.title) !== null && _state$conversation$t !== void 0 && _state$conversation$t.length && ((_state$conversation2 = state.conversation) === null || _state$conversation2 === void 0 ? void 0 : _state$conversation2.title) !== _helpers.NEW_CHAT) {
    return 'end';
  }
  return 'continue';
};
exports.shouldContinueGenerateTitle = shouldContinueGenerateTitle;
const shouldContinueGetConversation = ({
  logger,
  state,
  conversationId
}) => {
  logger.debug(`Node state:\n${JSON.stringify(state, null, 2)}`);
  if (!conversationId) {
    return 'end';
  }
  return 'continue';
};
exports.shouldContinueGetConversation = shouldContinueGetConversation;