"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgent = exports.AGENT_NODE_TAG = exports.AGENT_NODE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_NODE = exports.AGENT_NODE = 'agent';
const AGENT_NODE_TAG = exports.AGENT_NODE_TAG = 'agent_run';

/**
 * Node to run the agent
 *
 * @param agentRunnable - The agent to run
 * @param config - Any configuration that may've been supplied
 * @param logger - The scoped logger
 * @param dataClients - Data clients available for use
 * @param state - The current state of the graph
 */
const runAgent = async ({
  agentRunnable,
  config,
  dataClients,
  logger,
  state
}) => {
  logger.debug(`Node state:\n${JSON.stringify(state, null, 2)}`);
  const agentOutcome = await agentRunnable.withConfig({
    tags: [AGENT_NODE_TAG]
  }).invoke({
    ...state,
    chat_history: state.messages // TODO: Message de-dupe with ...state spread
  }, config);
  return {
    agentOutcome
  };
};
exports.runAgent = runAgent;