"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistConversationChanges = exports.PERSIST_CONVERSATION_CHANGES_NODE = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _helpers = require("../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERSIST_CONVERSATION_CHANGES_NODE = exports.PERSIST_CONVERSATION_CHANGES_NODE = 'persistConversationChanges';
const persistConversationChanges = async ({
  conversationsDataClient,
  conversationId,
  logger,
  state,
  replacements = {}
}) => {
  var _state$conversation, _updatedConversation$;
  logger.debug(`Node state:\n ${JSON.stringify(state, null, 2)}`);
  if (!state.conversation || !conversationId) {
    logger.debug('No need to generate chat title, conversationId is undefined');
    return {
      conversation: undefined,
      messages: []
    };
  }
  let conversation;
  if (((_state$conversation = state.conversation) === null || _state$conversation === void 0 ? void 0 : _state$conversation.title) !== state.chatTitle) {
    conversation = await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.updateConversation({
      conversationUpdateProps: {
        id: conversationId,
        title: state.chatTitle
      }
    }));
  }
  const lastMessage = state.conversation.messages ? state.conversation.messages[state.conversation.messages.length - 1] : undefined;
  if (lastMessage && lastMessage.content === state.input && lastMessage.role === 'user') {
    var _state$conversation$m;
    // this is a regenerated message, do not update the conversation again
    const langChainMessages = (0, _helpers.getLangChainMessages)((_state$conversation$m = state.conversation.messages) !== null && _state$conversation$m !== void 0 ? _state$conversation$m : []);
    const messages = langChainMessages.slice(0, -1); // all but the last message
    return {
      conversation: state.conversation,
      messages
    };
  }
  const updatedConversation = await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.appendConversationMessages({
    existingConversation: conversation ? conversation : state.conversation,
    messages: [{
      content: (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
        messageContent: state.input,
        replacements
      }),
      role: 'user',
      timestamp: new Date().toISOString()
    }]
  }));
  if (!updatedConversation) {
    logger.debug('Not updated conversation');
    return {
      conversation: undefined,
      messages: []
    };
  }
  logger.debug(`conversationId: ${conversationId}`);
  const langChainMessages = (0, _helpers.getLangChainMessages)((_updatedConversation$ = updatedConversation.messages) !== null && _updatedConversation$ !== void 0 ? _updatedConversation$ : []);
  const messages = langChainMessages.slice(0, -1); // all but the last message

  return {
    conversation: updatedConversation,
    messages
  };
};
exports.persistConversationChanges = persistConversationChanges;