"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPersistedConversation = exports.GET_PERSISTED_CONVERSATION_NODE = void 0;
var _helpers = require("../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_PERSISTED_CONVERSATION_NODE = exports.GET_PERSISTED_CONVERSATION_NODE = 'getPersistedConversation';
const getPersistedConversation = async ({
  conversationsDataClient,
  conversationId,
  logger,
  state
}) => {
  var _conversation$message;
  logger.debug(`Node state:\n ${JSON.stringify(state, null, 2)}`);
  if (!conversationId) {
    logger.debug('Cannot get conversation, because conversationId is undefined');
    return {
      conversation: undefined,
      messages: [],
      chatTitle: '',
      input: state.input
    };
  }
  const conversation = await (conversationsDataClient === null || conversationsDataClient === void 0 ? void 0 : conversationsDataClient.getConversation({
    id: conversationId
  }));
  if (!conversation) {
    logger.debug('Requested conversation, because conversation is undefined');
    return {
      conversation: undefined,
      messages: [],
      chatTitle: '',
      input: state.input
    };
  }
  logger.debug(`conversationId: ${conversationId}`);
  const messages = (0, _helpers.getLangChainMessages)((_conversation$message = conversation.messages) !== null && _conversation$message !== void 0 ? _conversation$message : []);
  if (!state.input) {
    const lastMessage = messages === null || messages === void 0 ? void 0 : messages.splice(-1)[0];
    return {
      conversation,
      messages,
      chatTitle: conversation.title,
      input: lastMessage === null || lastMessage === void 0 ? void 0 : lastMessage.content
    };
  }
  return {
    conversation,
    messages,
    chatTitle: conversation.title,
    input: state.input
  };
};
exports.getPersistedConversation = getPersistedConversation;