"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateChatTitle = exports.GENERATE_CHAT_TITLE_PROMPT = exports.GENERATE_CHAT_TITLE_NODE = void 0;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("@langchain/core/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERATE_CHAT_TITLE_PROMPT = responseLanguage => _prompts.ChatPromptTemplate.fromMessages([['system', `You are a helpful assistant for Elastic Security. Assume the following user message is the start of a conversation between you and a user; give this conversation a title based on the content below. DO NOT UNDER ANY CIRCUMSTANCES wrap this title in single or double quotes. This title is shown in a list of conversations to the user, so title it for the user, not for you. Please create the title in ${responseLanguage}. As an example, for the given MESSAGE, this is the TITLE:

    MESSAGE: I am having trouble with the Elastic Security app.
    TITLE: Troubleshooting Elastic Security app issues
    `], ['human', '{input}']]);
exports.GENERATE_CHAT_TITLE_PROMPT = GENERATE_CHAT_TITLE_PROMPT;
const GENERATE_CHAT_TITLE_NODE = exports.GENERATE_CHAT_TITLE_NODE = 'generateChatTitle';
const generateChatTitle = async ({
  responseLanguage,
  logger,
  model,
  state
}) => {
  logger.debug(`Node state:\n ${JSON.stringify(state, null, 2)}`);
  const outputParser = new _output_parsers.StringOutputParser();
  const graph = GENERATE_CHAT_TITLE_PROMPT(responseLanguage).pipe(model).pipe(outputParser);
  const chatTitle = await graph.invoke({
    input: JSON.stringify(state.input, null, 2)
  });
  logger.debug(`chatTitle: ${chatTitle}`);
  return {
    chatTitle
  };
};
exports.generateChatTitle = generateChatTitle;