"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformESToKnowledgeBase = exports.transformESSearchToKnowledgeBaseEntry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESSearchToKnowledgeBaseEntry = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    var _kbEntrySchema$users$, _kbEntrySchema$users;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const kbEntrySchema = hit._source;
    const kbEntry = {
      timestamp: kbEntrySchema['@timestamp'],
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id,
      createdAt: kbEntrySchema.created_at,
      createdBy: kbEntrySchema.created_by,
      updatedAt: kbEntrySchema.updated_at,
      updatedBy: kbEntrySchema.updated_by,
      users: (_kbEntrySchema$users$ = (_kbEntrySchema$users = kbEntrySchema.users) === null || _kbEntrySchema$users === void 0 ? void 0 : _kbEntrySchema$users.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _kbEntrySchema$users$ !== void 0 ? _kbEntrySchema$users$ : [],
      ...(kbEntrySchema.metadata ? {
        metadata: {
          kbResource: kbEntrySchema.metadata.kbResource,
          source: kbEntrySchema.metadata.source,
          required: kbEntrySchema.metadata.required
        }
      } : {}),
      namespace: kbEntrySchema.namespace,
      text: kbEntrySchema.text,
      ...(kbEntrySchema.vector ? {
        vector: {
          modelId: kbEntrySchema.vector.model_id,
          tokens: kbEntrySchema.vector.tokens
        }
      } : {})
    };
    return kbEntry;
  });
};
exports.transformESSearchToKnowledgeBaseEntry = transformESSearchToKnowledgeBaseEntry;
const transformESToKnowledgeBase = response => {
  return response.map(kbEntrySchema => {
    var _kbEntrySchema$users$2, _kbEntrySchema$users2;
    const kbEntry = {
      timestamp: kbEntrySchema['@timestamp'],
      id: kbEntrySchema.id,
      createdAt: kbEntrySchema.created_at,
      createdBy: kbEntrySchema.created_by,
      updatedAt: kbEntrySchema.updated_at,
      updatedBy: kbEntrySchema.updated_by,
      users: (_kbEntrySchema$users$2 = (_kbEntrySchema$users2 = kbEntrySchema.users) === null || _kbEntrySchema$users2 === void 0 ? void 0 : _kbEntrySchema$users2.map(user => ({
        id: user.id,
        name: user.name
      }))) !== null && _kbEntrySchema$users$2 !== void 0 ? _kbEntrySchema$users$2 : [],
      ...(kbEntrySchema.metadata ? {
        metadata: {
          kbResource: kbEntrySchema.metadata.kbResource,
          source: kbEntrySchema.metadata.source,
          required: kbEntrySchema.metadata.required
        }
      } : {}),
      namespace: kbEntrySchema.namespace,
      text: kbEntrySchema.text,
      ...(kbEntrySchema.vector ? {
        vector: {
          modelId: kbEntrySchema.vector.model_id,
          tokens: kbEntrySchema.vector.tokens
        }
      } : {})
    };
    return kbEntry;
  });
};
exports.transformESToKnowledgeBase = transformESToKnowledgeBase;