"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKnowledgeBaseEntry = void 0;
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKnowledgeBaseEntry = async ({
  esClient,
  logger,
  knowledgeBaseIndex,
  id,
  user
}) => {
  const filterByUser = [{
    nested: {
      path: 'users',
      query: {
        bool: {
          must: [{
            match: user.profile_uid ? {
              'users.id': user.profile_uid
            } : {
              'users.name': user.username
            }
          }]
        }
      }
    }
  }];
  try {
    var _knowledgeBaseEntry$;
    const response = await esClient.search({
      query: {
        bool: {
          must: [{
            bool: {
              should: [{
                term: {
                  _id: id
                }
              }]
            }
          }, ...filterByUser]
        }
      },
      _source: true,
      ignore_unavailable: true,
      index: knowledgeBaseIndex,
      seq_no_primary_term: true
    });
    const knowledgeBaseEntry = (0, _transforms.transformESSearchToKnowledgeBaseEntry)(response);
    return (_knowledgeBaseEntry$ = knowledgeBaseEntry[0]) !== null && _knowledgeBaseEntry$ !== void 0 ? _knowledgeBaseEntry$ : null;
  } catch (err) {
    logger.error(`Error fetching knowledge base entry: ${err} with id: ${id}`);
    throw err;
  }
};
exports.getKnowledgeBaseEntry = getKnowledgeBaseEntry;