"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToCreateSchema = exports.createKnowledgeBaseEntry = void 0;
var _uuid = require("uuid");
var _get_knowledge_base_entry = require("./get_knowledge_base_entry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createKnowledgeBaseEntry = async ({
  esClient,
  knowledgeBaseIndex,
  spaceId,
  user,
  knowledgeBaseEntry,
  logger
}) => {
  const createdAt = new Date().toISOString();
  const body = transformToCreateSchema(createdAt, spaceId, user, knowledgeBaseEntry);
  try {
    const response = await esClient.create({
      body,
      id: (0, _uuid.v4)(),
      index: knowledgeBaseIndex,
      refresh: 'wait_for'
    });
    return await (0, _get_knowledge_base_entry.getKnowledgeBaseEntry)({
      esClient,
      knowledgeBaseIndex,
      id: response._id,
      logger,
      user
    });
  } catch (err) {
    logger.error(`Error creating Knowledge Base Entry: ${err} with kbResource: ${knowledgeBaseEntry.metadata.kbResource}`);
    throw err;
  }
};
exports.createKnowledgeBaseEntry = createKnowledgeBaseEntry;
const transformToCreateSchema = (createdAt, spaceId, user, {
  metadata,
  text
}) => {
  var _user$profile_uid, _user$profile_uid2;
  return {
    '@timestamp': createdAt,
    created_at: createdAt,
    created_by: (_user$profile_uid = user.profile_uid) !== null && _user$profile_uid !== void 0 ? _user$profile_uid : 'unknown',
    updated_at: createdAt,
    updated_by: (_user$profile_uid2 = user.profile_uid) !== null && _user$profile_uid2 !== void 0 ? _user$profile_uid2 : 'unknown',
    users: [{
      id: user.profile_uid,
      name: user.username
    }],
    namespace: spaceId,
    metadata,
    text
  };
};
exports.transformToCreateSchema = transformToCreateSchema;