"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAttackDiscovery = exports.transformToUpdateScheme = void 0;
var uuid = _interopRequireWildcard(require("uuid"));
var _get_attack_discovery = require("./get_attack_discovery");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateAttackDiscovery = async ({
  esClient,
  logger,
  attackDiscoveryIndex,
  attackDiscoveryUpdateProps,
  user
}) => {
  const updatedAt = new Date().toISOString();
  const params = transformToUpdateScheme(updatedAt, attackDiscoveryUpdateProps);
  try {
    await esClient.update({
      refresh: 'wait_for',
      index: attackDiscoveryIndex,
      id: params.id,
      doc: params
    });
    const updatedAttackDiscovery = await (0, _get_attack_discovery.getAttackDiscovery)({
      esClient,
      attackDiscoveryIndex,
      id: params.id,
      logger,
      user
    });
    return updatedAttackDiscovery;
  } catch (err) {
    logger.warn(`Error updating attackDiscovery: ${err} by ID: ${params.id}`);
    throw err;
  }
};
exports.updateAttackDiscovery = updateAttackDiscovery;
const transformToUpdateScheme = (updatedAt, {
  alertsContextCount,
  apiConfig,
  attackDiscoveries,
  failureReason,
  generationIntervals,
  id,
  replacements,
  lastViewedAt,
  status
}) => {
  const averageIntervalMsObj = generationIntervals && generationIntervals.length > 0 ? {
    average_interval_ms: Math.trunc(generationIntervals.reduce((acc, interval) => acc + interval.durationMs, 0) / generationIntervals.length),
    generation_intervals: generationIntervals.map(interval => ({
      date: interval.date,
      duration_ms: interval.durationMs
    }))
  } : {};
  return {
    alerts_context_count: alertsContextCount,
    ...(apiConfig ? {
      api_config: {
        action_type_id: apiConfig.actionTypeId,
        connector_id: apiConfig.connectorId,
        default_system_prompt_id: apiConfig.defaultSystemPromptId,
        model: apiConfig.model,
        provider: apiConfig.provider
      }
    } : {}),
    ...(attackDiscoveries ? {
      attack_discoveries: attackDiscoveries.map(attackDiscovery => {
        var _attackDiscovery$id;
        return {
          id: (_attackDiscovery$id = attackDiscovery.id) !== null && _attackDiscovery$id !== void 0 ? _attackDiscovery$id : uuid.v4(),
          alert_ids: attackDiscovery.alertIds,
          title: attackDiscovery.title,
          details_markdown: attackDiscovery.detailsMarkdown,
          entity_summary_markdown: attackDiscovery.entitySummaryMarkdown,
          mitre_attack_tactics: attackDiscovery.mitreAttackTactics,
          summary_markdown: attackDiscovery.summaryMarkdown,
          timestamp: updatedAt
        };
      })
    } : {}),
    failure_reason: failureReason,
    id,
    replacements: replacements ? Object.keys(replacements).map(key => ({
      uuid: key,
      value: replacements[key]
    })) : undefined,
    ...(status ? {
      status
    } : {}),
    // only update updated_at time if this is not an update to last_viewed_at
    ...(lastViewedAt ? {
      last_viewed_at: lastViewedAt
    } : {
      updated_at: updatedAt
    }),
    ...averageIntervalMsObj
  };
};
exports.transformToUpdateScheme = transformToUpdateScheme;