"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAllAttackDiscoveries = void 0;
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ITEMS = 10000;
const findAllAttackDiscoveries = async ({
  esClient,
  logger,
  attackDiscoveryIndex,
  user
}) => {
  const filterByUser = [{
    nested: {
      path: 'users',
      query: {
        bool: {
          must: [{
            match: user.profile_uid ? {
              'users.id': user.profile_uid
            } : {
              'users.name': user.username
            }
          }]
        }
      }
    }
  }];
  try {
    const response = await esClient.search({
      query: {
        bool: {
          must: [...filterByUser]
        }
      },
      size: MAX_ITEMS,
      _source: true,
      ignore_unavailable: true,
      index: attackDiscoveryIndex,
      seq_no_primary_term: true
    });
    const attackDiscoveries = (0, _transforms.transformESSearchToAttackDiscovery)(response);
    return attackDiscoveries !== null && attackDiscoveries !== void 0 ? attackDiscoveries : [];
  } catch (err) {
    logger.error(`Error fetching attack discoveries: ${err}`);
    throw err;
  }
};
exports.findAllAttackDiscoveries = findAllAttackDiscoveries;