"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROMPTS_TABLE_MAX_PAGE_SIZE = exports.POST_ACTIONS_CONNECTOR_EXECUTE = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.MINIMUM_AI_ASSISTANT_LICENSE = exports.MAX_PROMPTS_TO_UPDATE_IN_PARALLEL = exports.MAX_CONVERSATIONS_TO_UPDATE_IN_PARALLEL = exports.MAX_ANONYMIZATION_FIELDS_TO_UPDATE_IN_PARALLEL = exports.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = exports.EVALUATE = exports.CONVERSATIONS_TABLE_MAX_PAGE_SIZE = exports.CAPABILITIES = exports.BASE_PATH = exports.ATTACK_DISCOVERY_CANCEL_BY_CONNECTOR_ID = exports.ATTACK_DISCOVERY_BY_CONNECTOR_ID = exports.ATTACK_DISCOVERY = exports.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'elasticAssistant';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'elasticAssistant';
const BASE_PATH = exports.BASE_PATH = '/internal/elastic_assistant';
const POST_ACTIONS_CONNECTOR_EXECUTE = exports.POST_ACTIONS_CONNECTOR_EXECUTE = `${BASE_PATH}/actions/connector/{connectorId}/_execute`;

// Attack discovery
const ATTACK_DISCOVERY = exports.ATTACK_DISCOVERY = `${BASE_PATH}/attack_discovery`;
const ATTACK_DISCOVERY_BY_CONNECTOR_ID = exports.ATTACK_DISCOVERY_BY_CONNECTOR_ID = `${ATTACK_DISCOVERY}/{connectorId}`;
const ATTACK_DISCOVERY_CANCEL_BY_CONNECTOR_ID = exports.ATTACK_DISCOVERY_CANCEL_BY_CONNECTOR_ID = `${ATTACK_DISCOVERY}/cancel/{connectorId}`;

// Model Evaluation
const EVALUATE = exports.EVALUATE = `${BASE_PATH}/evaluate`;
const MAX_CONVERSATIONS_TO_UPDATE_IN_PARALLEL = exports.MAX_CONVERSATIONS_TO_UPDATE_IN_PARALLEL = 50;
const CONVERSATIONS_TABLE_MAX_PAGE_SIZE = exports.CONVERSATIONS_TABLE_MAX_PAGE_SIZE = 100;
const MAX_ANONYMIZATION_FIELDS_TO_UPDATE_IN_PARALLEL = exports.MAX_ANONYMIZATION_FIELDS_TO_UPDATE_IN_PARALLEL = 50;
const ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = exports.ANONYMIZATION_FIELDS_TABLE_MAX_PAGE_SIZE = 100;
const MAX_PROMPTS_TO_UPDATE_IN_PARALLEL = exports.MAX_PROMPTS_TO_UPDATE_IN_PARALLEL = 50;
const PROMPTS_TABLE_MAX_PAGE_SIZE = exports.PROMPTS_TABLE_MAX_PAGE_SIZE = 100;

// Knowledge Base
const KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = exports.KNOWLEDGE_BASE_ENTRIES_TABLE_MAX_PAGE_SIZE = 100;

// Capabilities
const CAPABILITIES = exports.CAPABILITIES = `${BASE_PATH}/capabilities`;

/**
 Licensing requirements
 */
const MINIMUM_AI_ASSISTANT_LICENSE = exports.MINIMUM_AI_ASSISTANT_LICENSE = 'enterprise';