"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAnonymizationFields = exports.DEFAULT_ALLOW_REPLACEMENT = exports.DEFAULT_ALLOW = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** By default, these fields are allowed to be sent to the assistant */
const DEFAULT_ALLOW = exports.DEFAULT_ALLOW = ['_id', '@timestamp', 'cloud.availability_zone', 'cloud.provider', 'cloud.region', 'destination.ip', 'dns.question.name', 'dns.question.type', 'event.category', 'event.dataset', 'event.module', 'event.outcome', 'file.Ext.original.path', 'file.hash.sha256', 'file.name', 'file.path', 'group.id', 'group.name', 'host.asset.criticality', 'host.name', 'host.os.name', 'host.os.version', 'host.risk.calculated_level', 'host.risk.calculated_score_norm', 'kibana.alert.original_time', 'kibana.alert.risk_score', 'kibana.alert.rule.description', 'kibana.alert.rule.name', 'kibana.alert.rule.references', 'kibana.alert.rule.threat.framework', 'kibana.alert.rule.threat.tactic.id', 'kibana.alert.rule.threat.tactic.name', 'kibana.alert.rule.threat.tactic.reference', 'kibana.alert.rule.threat.technique.id', 'kibana.alert.rule.threat.technique.name', 'kibana.alert.rule.threat.technique.reference', 'kibana.alert.rule.threat.technique.subtechnique.id', 'kibana.alert.rule.threat.technique.subtechnique.name', 'kibana.alert.rule.threat.technique.subtechnique.reference', 'kibana.alert.severity', 'kibana.alert.workflow_status', 'message', 'network.protocol', 'process.args', 'process.code_signature.exists', 'process.code_signature.signing_id', 'process.code_signature.status', 'process.code_signature.subject_name', 'process.code_signature.trusted', 'process.command_line', 'process.executable', 'process.exit_code', 'process.Ext.memory_region.bytes_compressed_present', 'process.Ext.memory_region.malware_signature.all_names', 'process.Ext.memory_region.malware_signature.primary.matches', 'process.Ext.memory_region.malware_signature.primary.signature.name', 'process.Ext.token.integrity_level_name', 'process.hash.md5', 'process.hash.sha1', 'process.hash.sha256', 'process.name', 'process.parent.args', 'process.parent.args_count', 'process.parent.code_signature.exists', 'process.parent.code_signature.status', 'process.parent.code_signature.subject_name', 'process.parent.code_signature.trusted', 'process.parent.command_line', 'process.parent.executable', 'process.parent.name', 'process.pe.original_file_name', 'process.pid', 'process.working_directory', 'Ransomware.feature', 'Ransomware.files.data', 'Ransomware.files.entropy', 'Ransomware.files.extension', 'Ransomware.files.metrics', 'Ransomware.files.operation', 'Ransomware.files.path', 'Ransomware.files.score', 'Ransomware.version', 'rule.name', 'rule.reference', 'source.ip', 'threat.framework', 'threat.tactic.id', 'threat.tactic.name', 'threat.tactic.reference', 'threat.technique.id', 'threat.technique.name', 'threat.technique.reference', 'threat.technique.subtechnique.id', 'threat.technique.subtechnique.name', 'threat.technique.subtechnique.reference', 'user.asset.criticality', 'user.domain', 'user.name', 'user.risk.calculated_level', 'user.risk.calculated_score_norm'];

/** By default, these fields will be anonymized */
const DEFAULT_ALLOW_REPLACEMENT = exports.DEFAULT_ALLOW_REPLACEMENT = ['host.ip',
// not a default allow field, but anonymized by default
'host.name', 'user.name'];
const getDefaultAnonymizationFields = spaceId => {
  const changedAt = new Date().toISOString();
  return DEFAULT_ALLOW.map(field => ({
    '@timestamp': changedAt,
    created_at: changedAt,
    created_by: '',
    field,
    anonymized: DEFAULT_ALLOW_REPLACEMENT.includes(field),
    allowed: true,
    namespace: spaceId
  }));
};
exports.getDefaultAnonymizationFields = getDefaultAnonymizationFields;