"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindPromptsSortFieldEnum = exports.FindPromptsSortField = exports.FindPromptsResponse = exports.FindPromptsRequestQuery = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../common_attributes.gen");
var _bulk_crud_prompts_route = require("./bulk_crud_prompts_route.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Prompts API endpoint
 *   version: 1
 */

const FindPromptsSortField = exports.FindPromptsSortField = _zod.z.enum(['created_at', 'is_default', 'name', 'updated_at']);
const FindPromptsSortFieldEnum = exports.FindPromptsSortFieldEnum = FindPromptsSortField.enum;
const FindPromptsRequestQuery = exports.FindPromptsRequestQuery = _zod.z.object({
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Search query
   */
  filter: _zod.z.string().optional(),
  /**
   * Field to sort by
   */
  sort_field: FindPromptsSortField.optional(),
  /**
   * Sort order
   */
  sort_order: _common_attributes.SortOrder.optional(),
  /**
   * Page number
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * Prompts per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindPromptsResponse = exports.FindPromptsResponse = _zod.z.object({
  page: _zod.z.number().int(),
  perPage: _zod.z.number().int(),
  total: _zod.z.number().int(),
  data: _zod.z.array(_bulk_crud_prompts_route.PromptResponse)
});