"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptsBulkCrudActionResults = exports.PromptsBulkCrudActionResponse = exports.PromptsBulkActionSkipResult = exports.PromptsBulkActionSkipReason = exports.PromptUpdateProps = exports.PromptTypeEnum = exports.PromptType = exports.PromptResponse = exports.PromptDetailsInError = exports.PromptCreateProps = exports.PerformBulkActionResponse = exports.PerformBulkActionRequestBody = exports.NormalizedPromptError = exports.BulkCrudActionSummary = exports.BulkActionBase = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Prompts Actions API endpoint
 *   version: 1
 */

const PromptsBulkActionSkipReason = exports.PromptsBulkActionSkipReason = _zod.z.literal('PROMPT_FIELD_NOT_MODIFIED');
const PromptsBulkActionSkipResult = exports.PromptsBulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: PromptsBulkActionSkipReason
});
const PromptDetailsInError = exports.PromptDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});

/**
 * Prompt type
 */

const PromptType = exports.PromptType = _zod.z.enum(['system', 'quick']);
const PromptTypeEnum = exports.PromptTypeEnum = PromptType.enum;
const NormalizedPromptError = exports.NormalizedPromptError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  prompts: _zod.z.array(PromptDetailsInError)
});
const PromptResponse = exports.PromptResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyString.optional(),
  name: _zod.z.string(),
  promptType: PromptType,
  content: _zod.z.string(),
  categories: _zod.z.array(_zod.z.string()).optional(),
  color: _zod.z.string().optional(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  consumer: _zod.z.string().optional(),
  updatedAt: _zod.z.string().optional(),
  updatedBy: _zod.z.string().optional(),
  createdAt: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  users: _zod.z.array(_common_attributes.User).optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string().optional()
});
const PromptsBulkCrudActionResults = exports.PromptsBulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(PromptResponse),
  created: _zod.z.array(PromptResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(PromptsBulkActionSkipResult)
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const PromptsBulkCrudActionResponse = exports.PromptsBulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  prompts_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: PromptsBulkCrudActionResults,
    summary: BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedPromptError).optional()
  })
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter promps
   */
  query: _zod.z.string().optional(),
  /**
   * Array of prompts IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const PromptCreateProps = exports.PromptCreateProps = _zod.z.object({
  name: _zod.z.string(),
  promptType: PromptType,
  content: _zod.z.string(),
  color: _zod.z.string().optional(),
  categories: _zod.z.array(_zod.z.string()).optional(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  consumer: _zod.z.string().optional()
});
const PromptUpdateProps = exports.PromptUpdateProps = _zod.z.object({
  id: _zod.z.string(),
  content: _zod.z.string().optional(),
  color: _zod.z.string().optional(),
  categories: _zod.z.array(_zod.z.string()).optional(),
  isNewConversationDefault: _zod.z.boolean().optional(),
  isDefault: _zod.z.boolean().optional(),
  consumer: _zod.z.string().optional()
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.object({
  delete: BulkActionBase.optional(),
  create: _zod.z.array(PromptCreateProps).optional(),
  update: _zod.z.array(PromptUpdateProps).optional()
});
const PerformBulkActionResponse = exports.PerformBulkActionResponse = PromptsBulkCrudActionResponse;