"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Vector = exports.Metadata = exports.KnowledgeBaseEntryUpdateProps = exports.KnowledgeBaseEntryResponse = exports.KnowledgeBaseEntryErrorSchema = exports.KnowledgeBaseEntryCreateProps = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Knowledge Base Attributes
 *   version: not applicable
 */

const KnowledgeBaseEntryErrorSchema = exports.KnowledgeBaseEntryErrorSchema = _zod.z.object({
  statusCode: _zod.z.number(),
  error: _zod.z.string(),
  message: _zod.z.string()
}).strict();

/**
 * Metadata about an Knowledge Base Entry
 */

const Metadata = exports.Metadata = _zod.z.object({
  /**
   * Knowledge Base resource name for grouping entries, e.g. 'esql', 'lens-docs', etc
   */
  kbResource: _zod.z.string(),
  /**
   * Source document name or filepath
   */
  source: _zod.z.string(),
  /**
   * Whether or not this resource should always be included
   */
  required: _zod.z.boolean()
});

/**
 * Object containing Knowledge Base Entry text embeddings and modelId used to create the embeddings
 */

const Vector = exports.Vector = _zod.z.object({
  /**
   * ID of the model used to create the embeddings
   */
  modelId: _zod.z.string(),
  /**
   * Tokens with their corresponding values
   */
  tokens: _zod.z.object({}).catchall(_zod.z.number())
});
const KnowledgeBaseEntryResponse = exports.KnowledgeBaseEntryResponse = _zod.z.object({
  timestamp: _common_attributes.NonEmptyString.optional(),
  id: _common_attributes.NonEmptyString,
  /**
   * Time the Knowledge Base Entry was created
   */
  createdAt: _zod.z.string(),
  /**
   * User who created the Knowledge Base Entry
   */
  createdBy: _zod.z.string().optional(),
  /**
   * Time the Knowledge Base Entry was last updated
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * User who last updated the Knowledge Base Entry
   */
  updatedBy: _zod.z.string().optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * Metadata about the Knowledge Base Entry
   */
  metadata: Metadata.optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string(),
  /**
   * Knowledge Base Entry content
   */
  text: _zod.z.string(),
  vector: Vector.optional()
});
const KnowledgeBaseEntryUpdateProps = exports.KnowledgeBaseEntryUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * Metadata about the Knowledge Base Entry
   */
  metadata: Metadata.optional()
});
const KnowledgeBaseEntryCreateProps = exports.KnowledgeBaseEntryCreateProps = _zod.z.object({
  /**
   * Metadata about the Knowledge Base Entry
   */
  metadata: Metadata,
  /**
   * Knowledge Base Entry content
   */
  text: _zod.z.string()
});