"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostEvaluateResponse = exports.PostEvaluateRequestQuery = exports.PostEvaluateRequestBody = exports.PostEvaluateBody = exports.OutputIndex = exports.DatasetItem = exports.Dataset = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Post Evaluate API endpoint
 *   version: 1
 */

const OutputIndex = exports.OutputIndex = _zod.z.string().regex(/^.kibana-elastic-ai-assistant-/);
const DatasetItem = exports.DatasetItem = _zod.z.object({
  id: _zod.z.string().optional(),
  input: _zod.z.string(),
  prediction: _zod.z.string().optional(),
  reference: _zod.z.string(),
  tags: _zod.z.array(_zod.z.string()).optional()
});
const Dataset = exports.Dataset = _zod.z.array(DatasetItem).default([]);
const PostEvaluateBody = exports.PostEvaluateBody = _zod.z.object({
  dataset: Dataset.optional(),
  evalPrompt: _zod.z.string().optional()
});
const PostEvaluateRequestQuery = exports.PostEvaluateRequestQuery = _zod.z.object({
  /**
   * Agents parameter description
   */
  agents: _zod.z.string(),
  /**
   * Dataset Name parameter description
   */
  datasetName: _zod.z.string().optional(),
  /**
   * Evaluation Type parameter description
   */
  evaluationType: _zod.z.string().optional(),
  /**
   * Eval Model parameter description
   */
  evalModel: _zod.z.string().optional(),
  /**
   * Models parameter description
   */
  models: _zod.z.string(),
  /**
   * Output Index parameter description
   */
  outputIndex: OutputIndex,
  /**
   * Project Name parameter description
   */
  projectName: _zod.z.string().optional(),
  /**
   * Run Name parameter description
   */
  runName: _zod.z.string().optional()
});
const PostEvaluateRequestBody = exports.PostEvaluateRequestBody = PostEvaluateBody;
const PostEvaluateResponse = exports.PostEvaluateResponse = _zod.z.object({
  evaluationId: _zod.z.string(),
  success: _zod.z.boolean()
});