"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerationInterval = exports.AttackDiscoveryUpdateProps = exports.AttackDiscoveryStatusEnum = exports.AttackDiscoveryStatus = exports.AttackDiscoveryStats = exports.AttackDiscoveryStat = exports.AttackDiscoveryResponse = exports.AttackDiscoveryCreateProps = exports.AttackDiscovery = exports.AttackDiscoveries = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Attack Discovery Attributes
 *   version: not applicable
 */

/**
 * An attack discovery generated from one or more alerts
 */

const AttackDiscovery = exports.AttackDiscovery = _zod.z.object({
  /**
   * The alert IDs that the attack discovery is based on
   */
  alertIds: _zod.z.array(_zod.z.string()),
  /**
   * UUID of attack discovery
   */
  id: _zod.z.string().optional(),
  /**
   * Details of the attack with bulleted markdown that always uses special syntax for field names and values from the source data.
   */
  detailsMarkdown: _zod.z.string(),
  /**
   * A short (no more than a sentence) summary of the attack discovery featuring only the host.name and user.name fields (when they are applicable), using the same syntax
   */
  entitySummaryMarkdown: _zod.z.string(),
  /**
   * An array of MITRE ATT&CK tactic for the attack discovery
   */
  mitreAttackTactics: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A markdown summary of attack discovery, using the same syntax
   */
  summaryMarkdown: _zod.z.string(),
  /**
   * A title for the attack discovery, in plain text
   */
  title: _zod.z.string(),
  /**
   * The time the attack discovery was generated
   */
  timestamp: _common_attributes.NonEmptyString
});

/**
 * Array of attack discoveries
 */

const AttackDiscoveries = exports.AttackDiscoveries = _zod.z.array(AttackDiscovery);

/**
 * The status of the attack discovery.
 */

const AttackDiscoveryStatus = exports.AttackDiscoveryStatus = _zod.z.enum(['running', 'succeeded', 'failed', 'canceled']);
const AttackDiscoveryStatusEnum = exports.AttackDiscoveryStatusEnum = AttackDiscoveryStatus.enum;

/**
 * Run durations for the attack discovery
 */

const GenerationInterval = exports.GenerationInterval = _zod.z.object({
  /**
   * The time the attack discovery was generated
   */
  date: _zod.z.string(),
  /**
   * The duration of the attack discovery generation
   */
  durationMs: _zod.z.number().int()
});

/**
 * Attack discovery stats
 */

const AttackDiscoveryStat = exports.AttackDiscoveryStat = _zod.z.object({
  /**
   * Whether the user has viewed the results of the attack discovery run
   */
  hasViewed: _zod.z.boolean(),
  /**
   * The number of attack discoveries for the connector
   */
  count: _zod.z.number().int(),
  /**
   * The connector ID for the attack discovery
   */
  connectorId: _zod.z.string(),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus
});

/**
 * Stats on existing attack discovery documents
 */

const AttackDiscoveryStats = exports.AttackDiscoveryStats = _zod.z.object({
  /**
   * The number of attack discoveries that have not yet been viewed
   */
  newDiscoveriesCount: _zod.z.number().int(),
  /**
   * The number of connectors with new results that have not yet been viewed
   */
  newConnectorResultsCount: _zod.z.number().int(),
  /**
   * Attack discovery stats per connector
   */
  statsPerConnector: _zod.z.array(AttackDiscoveryStat)
});
const AttackDiscoveryResponse = exports.AttackDiscoveryResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyString.optional(),
  /**
   * The last time attack discovery was updated.
   */
  updatedAt: _zod.z.string(),
  /**
   * The last time attack discovery was viewed in the browser.
   */
  lastViewedAt: _zod.z.string(),
  /**
   * The number of alerts in the context.
   */
  alertsContextCount: _zod.z.number().int().optional(),
  /**
   * The time attack discovery was created.
   */
  createdAt: _zod.z.string(),
  replacements: _common_attributes2.Replacements.optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus,
  /**
   * The attack discoveries.
   */
  attackDiscoveries: AttackDiscoveries,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  /**
   * Kibana space
   */
  namespace: _zod.z.string(),
  /**
   * The backing index required for update requests.
   */
  backingIndex: _zod.z.string(),
  /**
   * The most 5 recent generation intervals
   */
  generationIntervals: _zod.z.array(GenerationInterval),
  /**
   * The average generation interval in milliseconds
   */
  averageIntervalMs: _zod.z.number().int(),
  /**
   * The reason for a status of failed.
   */
  failureReason: _zod.z.string().optional()
});
const AttackDiscoveryUpdateProps = exports.AttackDiscoveryUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig.optional(),
  /**
   * The number of alerts in the context.
   */
  alertsContextCount: _zod.z.number().int().optional(),
  /**
   * The attack discoveries.
   */
  attackDiscoveries: AttackDiscoveries.optional(),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus.optional(),
  replacements: _common_attributes2.Replacements.optional(),
  /**
   * The most 5 recent generation intervals
   */
  generationIntervals: _zod.z.array(GenerationInterval).optional(),
  /**
   * The backing index required for update requests.
   */
  backingIndex: _zod.z.string(),
  /**
   * The reason for a status of failed.
   */
  failureReason: _zod.z.string().optional(),
  /**
   * The last time attack discovery was viewed in the browser.
   */
  lastViewedAt: _zod.z.string().optional()
});
const AttackDiscoveryCreateProps = exports.AttackDiscoveryCreateProps = _zod.z.object({
  /**
   * The attack discovery id.
   */
  id: _zod.z.string().optional(),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus,
  /**
   * The number of alerts in the context.
   */
  alertsContextCount: _zod.z.number().int().optional(),
  /**
   * The attack discoveries.
   */
  attackDiscoveries: AttackDiscoveries,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  replacements: _common_attributes2.Replacements.optional()
});