"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnallowedFieldValuesRoute = void 0;
var _lib = require("../lib");
var _build_response = require("../lib/build_response");
var _constants = require("../../common/constants");
var _common = require("../schemas/common");
var _get_unallowed_field_values = require("../schemas/get_unallowed_field_values");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUnallowedFieldValuesRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.GET_UNALLOWED_FIELD_VALUES,
    access: 'internal'
  }).addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: {
      request: {
        body: (0, _common.buildRouteValidation)(_get_unallowed_field_values.GetUnallowedFieldValuesBody)
      }
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    try {
      const items = request.body;
      const {
        responses
      } = await (0, _lib.getUnallowedFieldValues)(esClient, items);
      return response.ok({
        body: responses
      });
    } catch (err) {
      var _err$message, _err$statusCode;
      logger.error(JSON.stringify(err));
      return resp.error({
        body: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : _translations.API_DEFAULT_ERROR_MESSAGE,
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500
      });
    }
  });
};
exports.getUnallowedFieldValuesRoute = getUnallowedFieldValuesRoute;