"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventsToNDJSON = eventsToNDJSON;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Converts an array of events to a single ndjson string.
 * @param events An array of events {@link Event}
 */
function eventsToNDJSON(events) {
  return `${events.map(event => JSON.stringify(event)).join('\n')}\n`;
}