"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformanceContext = void 0;
exports.usePerformanceContext = usePerformanceContext;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PerformanceContext = exports.PerformanceContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function usePerformanceContext() {
  const api = (0, _react.useContext)(PerformanceContext);
  if (!api) {
    throw new Error('Missing Performance API in context');
  }
  return api;
}