"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformanceContextProvider = PerformanceContextProvider;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _apmRumCore = require("@elastic/apm-rum-core");
var _reactRouterDom = require("react-router-dom");
var _performance_markers = require("../performance_markers");
var _use_performance_context = require("./use_performance_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function measureInteraction() {
  performance.mark(_performance_markers.perfomanceMarkers.startPageChange);
  const trackedRoutes = [];
  return {
    /**
     * Marks the end of the page ready state and measures the performance between the start of the page change and the end of the page ready state.
     * @param pathname - The pathname of the page.
     */
    pageReady(pathname) {
      performance.mark(_performance_markers.perfomanceMarkers.endPageReady);
      if (!trackedRoutes.includes(pathname)) {
        performance.measure(pathname, {
          detail: {
            eventName: 'kibana:plugin_render_time',
            type: 'kibana:performance'
          },
          start: _performance_markers.perfomanceMarkers.startPageChange,
          end: _performance_markers.perfomanceMarkers.endPageReady
        });
        trackedRoutes.push(pathname);
      }
    }
  };
}
function PerformanceContextProvider({
  children
}) {
  const [isRendered, setIsRendered] = (0, _react.useState)(false);
  const location = (0, _reactRouterDom.useLocation)();
  const interaction = measureInteraction();
  _react.default.useEffect(() => {
    (0, _apmRumCore.afterFrame)(() => {
      setIsRendered(true);
    });
    return () => {
      setIsRendered(false);
      performance.clearMeasures(location.pathname);
    };
  }, [location.pathname]);
  const api = (0, _react.useMemo)(() => ({
    onPageReady() {
      if (isRendered) {
        interaction.pageReady(location.pathname);
      }
    }
  }), [isRendered, location.pathname, interaction]);
  return /*#__PURE__*/_react.default.createElement(_use_performance_context.PerformanceContext.Provider, {
    value: api
  }, children);
}
// dynamic import
// eslint-disable-next-line import/no-default-export
var _default = exports.default = PerformanceContextProvider;