"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocLinks = void 0;
var _std = require("@kbn/std");
var _get_doc_meta = require("./get_doc_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDocLinks = ({
  kibanaBranch,
  buildFlavor
}) => {
  const meta = (0, _get_doc_meta.getDocLinksMeta)({
    kibanaBranch,
    buildFlavor
  });
  const DOC_LINK_VERSION = meta.version;
  const ECS_VERSION = meta.ecs_version;
  const ELASTIC_WEBSITE_URL = meta.elasticWebsiteUrl;
  const DOCS_WEBSITE_URL = meta.docsWebsiteUrl;
  const ELASTIC_GITHUB = meta.elasticGithubUrl;
  const SEARCH_LABS_URL = meta.searchLabsUrl;
  const ELASTICSEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/reference/${DOC_LINK_VERSION}/`;
  const KIBANA_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/kibana/${DOC_LINK_VERSION}/`;
  const FLEET_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/fleet/${DOC_LINK_VERSION}/`;
  const INTEGRATIONS_DEV_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/integrations-developer/current/`;
  const PLUGIN_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/plugins/${DOC_LINK_VERSION}/`;
  const OBSERVABILITY_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/`;
  const APM_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/apm/`;
  const SECURITY_SOLUTION_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/`;
  const APP_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/app-search/${DOC_LINK_VERSION}/`;
  const ENTERPRISE_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/enterprise-search/${DOC_LINK_VERSION}/`;
  const ESRE_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/esre/${DOC_LINK_VERSION}/`;
  const WORKPLACE_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/workplace-search/${DOC_LINK_VERSION}/`;
  const SEARCH_UI_DOCS = `${DOCS_WEBSITE_URL}search-ui/`;
  const MACHINE_LEARNING_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/`;
  const SERVERLESS_DOCS = `${DOCS_WEBSITE_URL}serverless/`;
  const SERVERLESS_ELASTICSEARCH_DOCS = `${SERVERLESS_DOCS}elasticsearch/`;
  const SERVERLESS_OBSERVABILITY_DOCS = `${SERVERLESS_DOCS}observability/`;
  const SEARCH_LABS_REPO = `${ELASTIC_GITHUB}elasticsearch-labs/`;
  const isServerless = buildFlavor === 'serverless';
  return (0, _std.deepFreeze)({
    settings: `${ELASTIC_WEBSITE_URL}guide/en/kibana/${DOC_LINK_VERSION}/settings.html`,
    elasticStackGetStarted: isServerless ? `${SERVERLESS_DOCS}` : `${ELASTIC_WEBSITE_URL}guide/en/index.html`,
    upgrade: {
      upgradingStackOnPrem: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/current/upgrading-elastic-stack-on-prem.html`,
      upgradingStackOnCloud: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/current/upgrade-elastic-stack-for-elastic-cloud.html`
    },
    apm: {
      kibanaSettings: `${KIBANA_DOCS}apm-settings-in-kibana.html`,
      supportedServiceMaps: isServerless ? `${SERVERLESS_DOCS}apm-service-map#supported-apm-agents` : `${KIBANA_DOCS}service-maps.html#service-maps-supported`,
      customLinks: isServerless ? `${SERVERLESS_DOCS}apm-create-custom-links` : `${KIBANA_DOCS}custom-links.html`,
      droppedTransactionSpans: `${APM_DOCS}guide/${DOC_LINK_VERSION}/data-model-spans.html#data-model-dropped-spans`,
      upgrading: `${APM_DOCS}guide/${DOC_LINK_VERSION}/upgrade.html`,
      metaData: `${APM_DOCS}guide/${DOC_LINK_VERSION}/data-model-metadata.html`,
      overview: `${APM_DOCS}guide/${DOC_LINK_VERSION}/apm-overview.html`,
      tailSamplingPolicies: isServerless ? `${SERVERLESS_DOCS}apm-transaction-sampling` : `${OBSERVABILITY_DOCS}configure-tail-based-sampling.html`,
      elasticAgent: `${APM_DOCS}guide/${DOC_LINK_VERSION}/upgrade-to-apm-integration.html`,
      storageExplorer: `${KIBANA_DOCS}storage-explorer.html`,
      spanCompression: isServerless ? `${SERVERLESS_DOCS}apm-compress-spans` : `${OBSERVABILITY_DOCS}span-compression.html`,
      transactionSampling: isServerless ? `${SERVERLESS_DOCS}apm-transaction-sampling` : `${OBSERVABILITY_DOCS}sampling.html`,
      indexLifecycleManagement: `${APM_DOCS}guide/${DOC_LINK_VERSION}/ilm-how-to.html`
    },
    canvas: {
      guide: `${KIBANA_DOCS}canvas.html`
    },
    cloud: {
      beatsAndLogstashConfiguration: `${ELASTIC_WEBSITE_URL}guide/en/cloud/current/ec-cloud-id.html`,
      indexManagement: `${ELASTIC_WEBSITE_URL}guide/en/cloud/current/ec-configure-index-management.html`
    },
    console: {
      guide: `${KIBANA_DOCS}console-kibana.html`,
      serverlessGuide: `${SERVERLESS_ELASTICSEARCH_DOCS}dev-tools-console`
    },
    dashboard: {
      guide: `${KIBANA_DOCS}dashboard.html`,
      drilldowns: `${KIBANA_DOCS}drilldowns.html`,
      drilldownsTriggerPicker: `${KIBANA_DOCS}create-drilldowns.html#url-drilldowns`,
      urlDrilldownTemplateSyntax: `${KIBANA_DOCS}create-drilldowns.html#url_templating-language`,
      urlDrilldownVariables: `${KIBANA_DOCS}create-drilldowns.html#url-template-variables`
    },
    discover: {
      guide: `${KIBANA_DOCS}discover.html`,
      fieldStatistics: `${KIBANA_DOCS}show-field-statistics.html`,
      fieldTypeHelp: `${ELASTICSEARCH_DOCS}mapping-types.html`,
      dateFieldTypeDocs: `${ELASTICSEARCH_DOCS}date.html`,
      dateFormatsDocs: `${ELASTICSEARCH_DOCS}mapping-date-format.html`,
      documentExplorer: `${KIBANA_DOCS}document-explorer.html`
    },
    filebeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}`,
      installation: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-installation-configuration.html`,
      configuration: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/configuring-howto-filebeat.html`,
      elasticsearchModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-elasticsearch.html`,
      elasticsearchOutput: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/elasticsearch-output.html`,
      startup: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-starting.html`,
      exportedFields: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/exported-fields.html`,
      suricataModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-suricata.html`,
      zeekModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-zeek.html`
    },
    auditbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}`,
      auditdModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}/auditbeat-module-auditd.html`,
      systemModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}/auditbeat-module-system.html`
    },
    appSearch: {
      adaptiveRelevance: `${APP_SEARCH_DOCS}curations-guide.html#curations-reference-adaptive-relevance`,
      apiRef: `${APP_SEARCH_DOCS}api-reference.html`,
      apiClients: `${APP_SEARCH_DOCS}api-clients.html`,
      apiKeys: `${APP_SEARCH_DOCS}authentication.html#authentication-api-keys`,
      authentication: `${APP_SEARCH_DOCS}authentication.html`,
      crawlRules: `${APP_SEARCH_DOCS}crawl-web-content.html#crawl-web-content-manage-crawl-rules`,
      curations: `${APP_SEARCH_DOCS}curations-guide.html`,
      duplicateDocuments: `${APP_SEARCH_DOCS}web-crawler-reference.html#web-crawler-reference-content-deduplication`,
      elasticsearchIndexedEngines: `${APP_SEARCH_DOCS}elasticsearch-engines.html`,
      entryPoints: `${APP_SEARCH_DOCS}crawl-web-content.html#crawl-web-content-manage-entry-points`,
      gettingStarted: `${APP_SEARCH_DOCS}getting-started.html`,
      guide: `${APP_SEARCH_DOCS}index.html`,
      indexingDocuments: `${APP_SEARCH_DOCS}indexing-documents-guide.html`,
      indexingDocumentsSchema: `${APP_SEARCH_DOCS}indexing-documents-guide.html#indexing-documents-guide-schema`,
      logSettings: `${APP_SEARCH_DOCS}logs.html`,
      metaEngines: `${APP_SEARCH_DOCS}meta-engines-guide.html`,
      precisionTuning: `${APP_SEARCH_DOCS}precision-tuning.html`,
      relevanceTuning: `${APP_SEARCH_DOCS}relevance-tuning-guide.html`,
      resultSettings: `${APP_SEARCH_DOCS}result-settings-guide.html`,
      searchUI: `${APP_SEARCH_DOCS}reference-ui-guide.html`,
      security: `${APP_SEARCH_DOCS}security-and-users.html`,
      synonyms: `${APP_SEARCH_DOCS}synonyms-guide.html`,
      webCrawler: `${APP_SEARCH_DOCS}web-crawler.html`,
      webCrawlerEventLogs: `${APP_SEARCH_DOCS}view-web-crawler-events-logs.html`,
      webCrawlerReference: `${APP_SEARCH_DOCS}web-crawler-reference.html`
    },
    enterpriseSearch: {
      aiSearchDoc: `${ESRE_DOCS}`,
      aiSearchHelp: `${ESRE_DOCS}help.html`,
      apiKeys: `${KIBANA_DOCS}api-keys.html`,
      behavioralAnalytics: `${ELASTICSEARCH_DOCS}behavioral-analytics-overview.html`,
      behavioralAnalyticsCORS: `${ELASTICSEARCH_DOCS}behavioral-analytics-cors.html`,
      behavioralAnalyticsEvents: `${ELASTICSEARCH_DOCS}behavioral-analytics-event.html`,
      buildConnector: `${ENTERPRISE_SEARCH_DOCS}build-connector.html`,
      bulkApi: `${ELASTICSEARCH_DOCS}docs-bulk.html`,
      configuration: `${ENTERPRISE_SEARCH_DOCS}configuration.html`,
      connectors: `${ENTERPRISE_SEARCH_DOCS}connectors.html`,
      connectorsClientDeploy: `${ENTERPRISE_SEARCH_DOCS}deploy-connector-client.html`,
      connectorsMappings: `${ENTERPRISE_SEARCH_DOCS}connectors-usage.html#connectors-usage-index-create-configure-existing-index`,
      connectorsAzureBlobStorage: `${ENTERPRISE_SEARCH_DOCS}connectors-azure-blob.html`,
      connectorsBox: `${ENTERPRISE_SEARCH_DOCS}connectors-box.html`,
      connectorsClients: `${ENTERPRISE_SEARCH_DOCS}connectors.html#connectors-build`,
      connectorsConfluence: `${ENTERPRISE_SEARCH_DOCS}connectors-confluence.html`,
      connectorsDropbox: `${ENTERPRISE_SEARCH_DOCS}connectors-dropbox.html`,
      connectorsContentExtraction: `${ENTERPRISE_SEARCH_DOCS}connectors-content-extraction.html`,
      connectorsGithub: `${ENTERPRISE_SEARCH_DOCS}connectors-github.html`,
      connectorsGmail: `${ENTERPRISE_SEARCH_DOCS}connectors-gmail.html`,
      connectorsGoogleCloudStorage: `${ENTERPRISE_SEARCH_DOCS}connectors-google-cloud.html`,
      connectorsGoogleDrive: `${ENTERPRISE_SEARCH_DOCS}connectors-google-drive.html`,
      connectorsJira: `${ENTERPRISE_SEARCH_DOCS}connectors-jira.html`,
      connectorsMicrosoftSQL: `${ENTERPRISE_SEARCH_DOCS}connectors-ms-sql.html`,
      connectorsMongoDB: `${ENTERPRISE_SEARCH_DOCS}connectors-mongodb.html`,
      connectorsMySQL: `${ENTERPRISE_SEARCH_DOCS}connectors-mysql.html`,
      connectorsNative: `${ENTERPRISE_SEARCH_DOCS}connectors.html#connectors-native`,
      connectorsNetworkDrive: `${ENTERPRISE_SEARCH_DOCS}connectors-network-drive.html`,
      connectorsNotion: `${ENTERPRISE_SEARCH_DOCS}connectors-notion.html`,
      connectorsOneDrive: `${ENTERPRISE_SEARCH_DOCS}connectors-onedrive.html`,
      connectorsOracle: `${ENTERPRISE_SEARCH_DOCS}connectors-oracle.html`,
      connectorsOutlook: `${ENTERPRISE_SEARCH_DOCS}connectors-outlook.html`,
      connectorsPostgreSQL: `${ENTERPRISE_SEARCH_DOCS}connectors-postgresql.html`,
      connectorsRedis: `${ENTERPRISE_SEARCH_DOCS}connectors-redis.html`,
      connectorsS3: `${ENTERPRISE_SEARCH_DOCS}connectors-s3.html`,
      connectorsSalesforce: `${ENTERPRISE_SEARCH_DOCS}connectors-salesforce.html`,
      connectorsServiceNow: `${ENTERPRISE_SEARCH_DOCS}connectors-servicenow.html`,
      connectorsSharepoint: `${ENTERPRISE_SEARCH_DOCS}connectors-sharepoint.html`,
      connectorsSharepointOnline: `${ENTERPRISE_SEARCH_DOCS}connectors-sharepoint-online.html`,
      connectorsSlack: `${ENTERPRISE_SEARCH_DOCS}connectors-slack.html`,
      connectorsTeams: `${ENTERPRISE_SEARCH_DOCS}connectors-teams.html`,
      connectorsZoom: `${ENTERPRISE_SEARCH_DOCS}connectors-zoom.html`,
      crawlerExtractionRules: `${ENTERPRISE_SEARCH_DOCS}crawler-extraction-rules.html`,
      crawlerManaging: `${ENTERPRISE_SEARCH_DOCS}crawler-managing.html`,
      crawlerOverview: `${ENTERPRISE_SEARCH_DOCS}crawler.html`,
      deployTrainedModels: `${MACHINE_LEARNING_DOCS}ml-nlp-deploy-models.html`,
      documentLevelSecurity: `${ELASTICSEARCH_DOCS}document-level-security.html`,
      e5Model: `${MACHINE_LEARNING_DOCS}ml-nlp-e5.html`,
      elser: `${ELASTICSEARCH_DOCS}semantic-search-elser.html`,
      engines: `${ENTERPRISE_SEARCH_DOCS}engines.html`,
      indexApi: `${ELASTICSEARCH_DOCS}docs-index_.html`,
      inferenceApiCreate: `${ELASTICSEARCH_DOCS}put-inference-api.html`,
      ingestionApis: `${ELASTICSEARCH_DOCS}search-with-elasticsearch.html`,
      ingestPipelines: `${ELASTICSEARCH_DOCS}ingest-pipeline-search.html`,
      knnSearch: `${ELASTICSEARCH_DOCS}knn-search.html`,
      knnSearchCombine: `${ELASTICSEARCH_DOCS}knn-search.html#_combine_approximate_knn_with_other_features`,
      languageAnalyzers: `${ELASTICSEARCH_DOCS}analysis-lang-analyzer.html`,
      languageClients: `${ENTERPRISE_SEARCH_DOCS}programming-language-clients.html`,
      licenseManagement: `${ENTERPRISE_SEARCH_DOCS}license-management.html`,
      machineLearningStart: `${ELASTICSEARCH_DOCS}nlp-example.html`,
      mailService: `${ENTERPRISE_SEARCH_DOCS}mailer-configuration.html`,
      mlDocumentEnrichment: `${ELASTICSEARCH_DOCS}ingest-pipeline-search-inference.html`,
      searchApplicationsTemplates: `${ELASTICSEARCH_DOCS}search-application-api.html`,
      searchApplicationsSearchApi: `${ELASTICSEARCH_DOCS}search-application-security.html`,
      searchApplications: `${ELASTICSEARCH_DOCS}search-application-overview.html`,
      searchApplicationsSearch: `${ELASTICSEARCH_DOCS}search-application-client.html`,
      searchLabs: `${SEARCH_LABS_URL}`,
      searchLabsRepo: `${SEARCH_LABS_REPO}`,
      searchTemplates: `${ELASTICSEARCH_DOCS}search-template.html`,
      semanticTextField: `${ELASTICSEARCH_DOCS}semantic-text.html`,
      start: `${ENTERPRISE_SEARCH_DOCS}start.html`,
      supportedNlpModels: `${MACHINE_LEARNING_DOCS}ml-nlp-model-ref.html`,
      syncRules: `${ENTERPRISE_SEARCH_DOCS}sync-rules.html`,
      syncRulesAdvanced: `${ENTERPRISE_SEARCH_DOCS}sync-rules.html#sync-rules-advanced`,
      trainedModels: `${MACHINE_LEARNING_DOCS}ml-trained-models.html`,
      textEmbedding: `${MACHINE_LEARNING_DOCS}ml-nlp-model-ref.html#ml-nlp-model-ref-text-embedding`,
      troubleshootSetup: `${ENTERPRISE_SEARCH_DOCS}troubleshoot-setup.html`,
      usersAccess: `${ENTERPRISE_SEARCH_DOCS}users-access.html`
    },
    workplaceSearch: {
      apiKeys: `${WORKPLACE_SEARCH_DOCS}workplace-search-api-authentication.html`,
      box: `${WORKPLACE_SEARCH_DOCS}workplace-search-box-connector.html`,
      confluenceCloud: `${WORKPLACE_SEARCH_DOCS}workplace-search-confluence-cloud-connector.html`,
      confluenceCloudConnectorPackage: `${WORKPLACE_SEARCH_DOCS}confluence-cloud.html`,
      confluenceServer: `${WORKPLACE_SEARCH_DOCS}workplace-search-confluence-server-connector.html`,
      contentSources: `${WORKPLACE_SEARCH_DOCS}workplace-search-content-sources.html`,
      customConnectorPackage: `${WORKPLACE_SEARCH_DOCS}custom-connector-package.html`,
      customSources: `${WORKPLACE_SEARCH_DOCS}workplace-search-custom-api-sources.html`,
      customSourcePermissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-custom-api-sources.html#custom-api-source-document-level-access-control`,
      documentPermissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-sources-document-permissions.html`,
      dropbox: `${WORKPLACE_SEARCH_DOCS}workplace-search-dropbox-connector.html`,
      externalSharePointOnline: `${WORKPLACE_SEARCH_DOCS}sharepoint-online-external.html`,
      externalIdentities: `${WORKPLACE_SEARCH_DOCS}workplace-search-external-identities-api.html`,
      gatedFormBlog: `${ELASTIC_WEBSITE_URL}blog/evolution-workplace-search-private-data-elasticsearch`,
      gettingStarted: `${WORKPLACE_SEARCH_DOCS}workplace-search-getting-started.html`,
      gitHub: `${WORKPLACE_SEARCH_DOCS}workplace-search-github-connector.html`,
      gmail: `${WORKPLACE_SEARCH_DOCS}workplace-search-gmail-connector.html`,
      googleDrive: `${WORKPLACE_SEARCH_DOCS}workplace-search-google-drive-connector.html`,
      indexingSchedule: `${WORKPLACE_SEARCH_DOCS}workplace-search-customizing-indexing-rules.html#_indexing_schedule`,
      jiraCloud: `${WORKPLACE_SEARCH_DOCS}workplace-search-jira-cloud-connector.html`,
      jiraServer: `${WORKPLACE_SEARCH_DOCS}workplace-search-jira-server-connector.html`,
      networkDrive: `${WORKPLACE_SEARCH_DOCS}network-drives.html`,
      oneDrive: `${WORKPLACE_SEARCH_DOCS}workplace-search-onedrive-connector.html`,
      permissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-permissions.html`,
      privateSourcePermissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-permissions.html#organizational-sources-private-sources`,
      salesforce: `${WORKPLACE_SEARCH_DOCS}workplace-search-salesforce-connector.html`,
      security: `${WORKPLACE_SEARCH_DOCS}workplace-search-security.html`,
      serviceNow: `${WORKPLACE_SEARCH_DOCS}workplace-search-servicenow-connector.html`,
      sharePoint: `${WORKPLACE_SEARCH_DOCS}workplace-search-sharepoint-online-connector.html`,
      sharePointServer: `${WORKPLACE_SEARCH_DOCS}sharepoint-server.html`,
      slack: `${WORKPLACE_SEARCH_DOCS}workplace-search-slack-connector.html`,
      synch: `${WORKPLACE_SEARCH_DOCS}workplace-search-customizing-indexing-rules.html`,
      zendesk: `${WORKPLACE_SEARCH_DOCS}workplace-search-zendesk-connector.html`
    },
    metricbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}`,
      configure: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/configuring-howto-metricbeat.html`,
      httpEndpoint: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/http-endpoint.html`,
      install: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/metricbeat-installation-configuration.html`,
      start: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/metricbeat-starting.html`
    },
    heartbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/heartbeat/${DOC_LINK_VERSION}`
    },
    libbeat: {
      getStarted: `${ELASTIC_WEBSITE_URL}guide/en/beats/libbeat/${DOC_LINK_VERSION}/getting-started.html`
    },
    logstash: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}`,
      inputElasticAgent: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}/plugins-inputs-elastic_agent.html`
    },
    functionbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/functionbeat/${DOC_LINK_VERSION}`
    },
    winlogbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/winlogbeat/${DOC_LINK_VERSION}`
    },
    aggs: {
      composite: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-composite-aggregation.html`,
      composite_missing_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-composite-aggregation.html#_missing_bucket`,
      date_histogram: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-datehistogram-aggregation.html`,
      date_range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-daterange-aggregation.html`,
      date_format_pattern: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-daterange-aggregation.html#date-format-pattern`,
      filter: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-filter-aggregation.html`,
      filters: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-filters-aggregation.html`,
      geohash_grid: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-geohashgrid-aggregation.html`,
      histogram: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-histogram-aggregation.html`,
      ip_range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-iprange-aggregation.html`,
      range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-range-aggregation.html`,
      significant_terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-significantterms-aggregation.html`,
      terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-terms-aggregation.html`,
      terms_doc_count_error: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-terms-aggregation.html#_per_bucket_document_count_error`,
      rare_terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-rare-terms-aggregation.html`,
      avg: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-avg-aggregation.html`,
      avg_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-avg-bucket-aggregation.html`,
      max_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-max-bucket-aggregation.html`,
      min_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-min-bucket-aggregation.html`,
      sum_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-sum-bucket-aggregation.html`,
      cardinality: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-cardinality-aggregation.html`,
      count: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-valuecount-aggregation.html`,
      cumulative_sum: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-sum-aggregation.html`,
      derivative: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-derivative-aggregation.html`,
      geo_bounds: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-geobounds-aggregation.html`,
      geo_centroid: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-geocentroid-aggregation.html`,
      max: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-max-aggregation.html`,
      median: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-percentile-aggregation.html`,
      min: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-min-aggregation.html`,
      moving_avg: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-movfn-aggregation.html`,
      percentile_ranks: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-percentile-rank-aggregation.html`,
      serial_diff: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-serialdiff-aggregation.html`,
      std_dev: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-extendedstats-aggregation.html`,
      sum: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-sum-aggregation.html`,
      top_hits: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-top-hits-aggregation.html`,
      top_metrics: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-top-metrics.html`,
      change_point: `${ELASTICSEARCH_DOCS}search-aggregations-change-point-aggregation.html`
    },
    runtimeFields: {
      overview: `${ELASTICSEARCH_DOCS}runtime.html`,
      mapping: `${ELASTICSEARCH_DOCS}runtime-mapping-fields.html`
    },
    scriptedFields: {
      scriptFields: `${ELASTICSEARCH_DOCS}search-request-script-fields.html`,
      scriptAggs: `${ELASTICSEARCH_DOCS}search-aggregations.html`,
      painless: `${ELASTICSEARCH_DOCS}modules-scripting-painless.html`,
      painlessApi: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-api-reference.html`,
      painlessLangSpec: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-lang-spec.html`,
      painlessSyntax: `${ELASTICSEARCH_DOCS}modules-scripting-painless-syntax.html`,
      painlessWalkthrough: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-walkthrough.html`,
      painlessLanguage: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-lang-spec.html`,
      luceneExpressions: `${ELASTICSEARCH_DOCS}modules-scripting-expression.html`
    },
    indexPatterns: {
      introduction: isServerless ? `${SERVERLESS_DOCS}data-views` : `${KIBANA_DOCS}data-views.html`,
      fieldFormattersNumber: `${KIBANA_DOCS}numeral.html`,
      fieldFormattersString: `${KIBANA_DOCS}managing-data-views.html#string-field-formatters`,
      runtimeFields: `${KIBANA_DOCS}managing-data-views.html#runtime-fields`
    },
    addData: `${KIBANA_DOCS}connect-to-elasticsearch.html`,
    kibana: {
      askElastic: `${ELASTIC_WEBSITE_URL}products/kibana/ask-elastic?blade=kibanaaskelastic`,
      createGithubIssue: `${ELASTIC_GITHUB}kibana/issues/new/choose`,
      feedback: `${ELASTIC_WEBSITE_URL}products/kibana/feedback?blade=kibanafeedback`,
      guide: `${KIBANA_DOCS}index.html`,
      autocompleteSuggestions: `${KIBANA_DOCS}kibana-concepts-analysts.html#autocomplete-suggestions`,
      secureSavedObject: `${KIBANA_DOCS}xpack-security-secure-saved-objects.html`,
      xpackSecurity: `${KIBANA_DOCS}xpack-security.html`
    },
    upgradeAssistant: {
      overview: `${KIBANA_DOCS}upgrade-assistant.html`,
      batchReindex: `${KIBANA_DOCS}batch-start-resume-reindex.html`,
      remoteReindex: `${ELASTICSEARCH_DOCS}docs-reindex.html#reindex-from-remote`,
      reindexWithPipeline: `${ELASTICSEARCH_DOCS}docs-reindex.html#reindex-with-an-ingest-pipeline`
    },
    rollupJobs: `${KIBANA_DOCS}data-rollups.html`,
    elasticsearch: {
      docsBase: `${ELASTICSEARCH_DOCS}`,
      asyncSearch: `${ELASTICSEARCH_DOCS}async-search-intro.html`,
      dataStreams: `${ELASTICSEARCH_DOCS}data-streams.html`,
      deprecationLogging: `${ELASTICSEARCH_DOCS}logging.html#deprecation-logging`,
      createEnrichPolicy: `${ELASTICSEARCH_DOCS}put-enrich-policy-api.html`,
      matchAllQuery: `${ELASTICSEARCH_DOCS}query-dsl-match-all-query.html`,
      enrichPolicies: `${ELASTICSEARCH_DOCS}ingest-enriching-data.html#enrich-policy`,
      createIndex: `${ELASTICSEARCH_DOCS}indices-create-index.html`,
      frozenIndices: `${ELASTICSEARCH_DOCS}frozen-indices.html`,
      gettingStarted: `${ELASTICSEARCH_DOCS}getting-started.html`,
      hiddenIndices: `${ELASTICSEARCH_DOCS}multi-index.html#hidden`,
      ilm: `${ELASTICSEARCH_DOCS}index-lifecycle-management.html`,
      ilmForceMerge: `${ELASTICSEARCH_DOCS}ilm-forcemerge.html`,
      ilmFreeze: `${ELASTICSEARCH_DOCS}ilm-freeze.html`,
      ilmPhaseTransitions: `${ELASTICSEARCH_DOCS}ilm-index-lifecycle.html#ilm-phase-transitions`,
      ilmReadOnly: `${ELASTICSEARCH_DOCS}ilm-readonly.html`,
      ilmRollover: `${ELASTICSEARCH_DOCS}ilm-rollover.html`,
      ilmSearchableSnapshot: `${ELASTICSEARCH_DOCS}ilm-searchable-snapshot.html`,
      ilmSetPriority: `${ELASTICSEARCH_DOCS}ilm-set-priority.html`,
      ilmShrink: `${ELASTICSEARCH_DOCS}ilm-shrink.html`,
      ilmWaitForSnapshot: `${ELASTICSEARCH_DOCS}ilm-wait-for-snapshot.html`,
      indexModules: `${ELASTICSEARCH_DOCS}index-modules.html`,
      indexSettings: `${ELASTICSEARCH_DOCS}index-modules.html#index-modules-settings`,
      dynamicIndexSettings: `${ELASTICSEARCH_DOCS}index-modules.html#dynamic-index-settings`,
      indexTemplates: `${ELASTICSEARCH_DOCS}index-templates.html`,
      mapping: `${ELASTICSEARCH_DOCS}mapping.html`,
      mappingAnalyzer: `${ELASTICSEARCH_DOCS}analyzer.html`,
      mappingCoerce: `${ELASTICSEARCH_DOCS}coerce.html`,
      mappingCopyTo: `${ELASTICSEARCH_DOCS}copy-to.html`,
      mappingDocValues: `${ELASTICSEARCH_DOCS}doc-values.html`,
      mappingDynamic: `${ELASTICSEARCH_DOCS}dynamic.html`,
      mappingDynamicFields: `${ELASTICSEARCH_DOCS}dynamic-field-mapping.html`,
      mappingDynamicTemplates: `${ELASTICSEARCH_DOCS}dynamic-templates.html`,
      mappingEagerGlobalOrdinals: `${ELASTICSEARCH_DOCS}eager-global-ordinals.html`,
      mappingEnabled: `${ELASTICSEARCH_DOCS}enabled.html`,
      mappingFieldData: `${ELASTICSEARCH_DOCS}text.html#fielddata-mapping-param`,
      mappingFieldDataEnable: `${ELASTICSEARCH_DOCS}text.html#before-enabling-fielddata`,
      mappingFieldDataFilter: `${ELASTICSEARCH_DOCS}text.html#field-data-filtering`,
      mappingFieldDataTypes: `${ELASTICSEARCH_DOCS}mapping-types.html`,
      mappingFormat: `${ELASTICSEARCH_DOCS}mapping-date-format.html`,
      mappingIgnoreAbove: `${ELASTICSEARCH_DOCS}ignore-above.html`,
      mappingIgnoreMalformed: `${ELASTICSEARCH_DOCS}ignore-malformed.html`,
      mappingIndex: `${ELASTICSEARCH_DOCS}mapping-index.html`,
      mappingIndexOptions: `${ELASTICSEARCH_DOCS}index-options.html`,
      mappingIndexPhrases: `${ELASTICSEARCH_DOCS}index-phrases.html`,
      mappingIndexPrefixes: `${ELASTICSEARCH_DOCS}index-prefixes.html`,
      mappingJoinFieldsPerformance: `${ELASTICSEARCH_DOCS}parent-join.html#_parent_join_and_performance`,
      mappingMeta: `${ELASTICSEARCH_DOCS}mapping-field-meta.html`,
      mappingMetaFields: `${ELASTICSEARCH_DOCS}mapping-meta-field.html`,
      mappingMultifields: `${ELASTICSEARCH_DOCS}multi-fields.html`,
      mappingNormalizer: `${ELASTICSEARCH_DOCS}normalizer.html`,
      mappingNorms: `${ELASTICSEARCH_DOCS}norms.html`,
      mappingNullValue: `${ELASTICSEARCH_DOCS}null-value.html`,
      mappingParameters: `${ELASTICSEARCH_DOCS}mapping-params.html`,
      mappingPositionIncrementGap: `${ELASTICSEARCH_DOCS}position-increment-gap.html`,
      mappingRankFeatureFields: `${ELASTICSEARCH_DOCS}rank-feature.html`,
      mappingRouting: `${ELASTICSEARCH_DOCS}mapping-routing-field.html`,
      mappingSimilarity: `${ELASTICSEARCH_DOCS}similarity.html`,
      mappingSourceFields: `${ELASTICSEARCH_DOCS}mapping-source-field.html`,
      mappingSourceFieldsDisable: `${ELASTICSEARCH_DOCS}mapping-source-field.html#disable-source-field`,
      mappingStore: `${ELASTICSEARCH_DOCS}mapping-store.html`,
      mappingSubobjects: `${ELASTICSEARCH_DOCS}subobjects.html`,
      mappingTermVector: `${ELASTICSEARCH_DOCS}term-vector.html`,
      mappingTypesRemoval: `${ELASTICSEARCH_DOCS}removal-of-types.html`,
      migrateIndexAllocationFilters: `${ELASTICSEARCH_DOCS}migrate-index-allocation-filters.html`,
      migrationApiDeprecation: `${ELASTICSEARCH_DOCS}migration-api-deprecation.html`,
      nodeRoles: `${ELASTICSEARCH_DOCS}modules-node.html#node-roles`,
      releaseHighlights: `${ELASTICSEARCH_DOCS}release-highlights.html`,
      latestReleaseHighlights: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/current/elastic-stack-highlights.html`,
      remoteClusters: `${ELASTICSEARCH_DOCS}remote-clusters.html`,
      remoteClustersProxy: `${ELASTICSEARCH_DOCS}remote-clusters.html#proxy-mode`,
      remoteClusersProxySettings: `${ELASTICSEARCH_DOCS}remote-clusters-settings.html#remote-cluster-proxy-settings`,
      remoteClustersOnPremSetupTrustWithCert: `${ELASTICSEARCH_DOCS}remote-clusters-cert.html`,
      remoteClustersOnPremSetupTrustWithApiKey: `${ELASTICSEARCH_DOCS}remote-clusters-api-key.html`,
      remoteClustersCloudSetupTrust: `${ELASTIC_WEBSITE_URL}guide/en/cloud/current/ec-enable-ccs.html`,
      rollupMigratingToDownsampling: `${ELASTICSEARCH_DOCS}rollup-migrating-to-downsampling.html`,
      rrf: `${ELASTICSEARCH_DOCS}rrf.html`,
      scriptParameters: `${ELASTICSEARCH_DOCS}modules-scripting-using.html#prefer-params`,
      secureCluster: `${ELASTICSEARCH_DOCS}secure-cluster.html`,
      shardAllocationSettings: `${ELASTICSEARCH_DOCS}modules-cluster.html#cluster-shard-allocation-settings`,
      sortSearch: `${ELASTICSEARCH_DOCS}sort-search-results.html`,
      tutorialUpdateExistingDataStream: `${ELASTICSEARCH_DOCS}tutorial-manage-existing-data-stream.html`,
      transportSettings: `${ELASTICSEARCH_DOCS}modules-network.html#common-network-settings`,
      typesRemoval: `${ELASTICSEARCH_DOCS}removal-of-types.html`,
      setupUpgrade: `${ELASTICSEARCH_DOCS}setup-upgrade.html`,
      apiCompatibilityHeader: `${ELASTICSEARCH_DOCS}api-conventions.html#api-compatibility`
    },
    siem: {
      guide: `${SECURITY_SOLUTION_DOCS}index.html`,
      gettingStarted: `${SECURITY_SOLUTION_DOCS}index.html`,
      privileges: `${SECURITY_SOLUTION_DOCS}sec-requirements.html`,
      ml: `${SECURITY_SOLUTION_DOCS}machine-learning.html`,
      ruleChangeLog: `${SECURITY_SOLUTION_DOCS}prebuilt-rules-downloadable-updates.html`,
      detectionsReq: `${SECURITY_SOLUTION_DOCS}detections-permissions-section.html`,
      networkMap: `${SECURITY_SOLUTION_DOCS}conf-map-ui.html`,
      troubleshootGaps: `${SECURITY_SOLUTION_DOCS}alerts-ui-monitor.html#troubleshoot-gaps`,
      ruleApiOverview: `${SECURITY_SOLUTION_DOCS}rule-api-overview.html`,
      configureAlertSuppression: `${SECURITY_SOLUTION_DOCS}alert-suppression.html#_configure_alert_suppression`
    },
    securitySolution: {
      artifactControl: `${SECURITY_SOLUTION_DOCS}artifact-control.html`,
      avcResults: `${ELASTIC_WEBSITE_URL}blog/elastic-security-malware-protection-test-av-comparatives`,
      trustedApps: `${SECURITY_SOLUTION_DOCS}trusted-apps-ov.html`,
      eventFilters: `${SECURITY_SOLUTION_DOCS}event-filters.html`,
      blocklist: `${SECURITY_SOLUTION_DOCS}blocklist.html`,
      threatIntelInt: `${SECURITY_SOLUTION_DOCS}es-threat-intel-integrations.html`,
      endpointArtifacts: `${SECURITY_SOLUTION_DOCS}endpoint-artifacts.html`,
      policyResponseTroubleshooting: {
        full_disk_access: `${SECURITY_SOLUTION_DOCS}deploy-elastic-endpoint.html#enable-fda-endpoint`,
        macos_system_ext: `${SECURITY_SOLUTION_DOCS}deploy-elastic-endpoint.html#system-extension-endpoint`,
        linux_deadlock: `${SECURITY_SOLUTION_DOCS}ts-management.html#linux-deadlock`
      },
      packageActionTroubleshooting: {
        es_connection: `${SECURITY_SOLUTION_DOCS}ts-management.html`
      },
      responseActions: `${SECURITY_SOLUTION_DOCS}response-actions.html`,
      configureEndpointIntegrationPolicy: `${SECURITY_SOLUTION_DOCS}configure-endpoint-integration-policy.html`,
      exceptions: {
        value_lists: `${SECURITY_SOLUTION_DOCS}value-lists-exceptions.html`
      },
      privileges: `${SECURITY_SOLUTION_DOCS}endpoint-management-req.html`,
      manageDetectionRules: `${SECURITY_SOLUTION_DOCS}rules-ui-management.html`,
      createDetectionRules: `${SECURITY_SOLUTION_DOCS}rules-ui-create.html`,
      createEsqlRuleType: `${SECURITY_SOLUTION_DOCS}rules-ui-create.html#create-esql-rule`,
      ruleUiAdvancedParams: `${SECURITY_SOLUTION_DOCS}rules-ui-create.html#rule-ui-advanced-params`,
      entityAnalytics: {
        riskScorePrerequisites: `${SECURITY_SOLUTION_DOCS}ers-requirements.html`,
        entityRiskScoring: `${SECURITY_SOLUTION_DOCS}entity-risk-scoring.html`,
        assetCriticality: `${SECURITY_SOLUTION_DOCS}asset-criticality.html`
      },
      detectionEngineOverview: `${SECURITY_SOLUTION_DOCS}detection-engine-overview.html`,
      aiAssistant: `${SECURITY_SOLUTION_DOCS}security-assistant.html`
    },
    query: {
      eql: `${ELASTICSEARCH_DOCS}eql.html`,
      kueryQuerySyntax: `${KIBANA_DOCS}kuery-query.html`,
      luceneQuery: `${ELASTICSEARCH_DOCS}query-dsl-query-string-query.html`,
      luceneQuerySyntax: `${ELASTICSEARCH_DOCS}query-dsl-query-string-query.html#query-string-syntax`,
      percolate: `${ELASTICSEARCH_DOCS}query-dsl-percolate-query.html`,
      queryDsl: `${ELASTICSEARCH_DOCS}query-dsl.html`,
      queryESQL: `${ELASTICSEARCH_DOCS}esql.html`
    },
    search: {
      sessions: `${KIBANA_DOCS}search-sessions.html`,
      sessionLimits: `${KIBANA_DOCS}search-sessions.html#_limitations`
    },
    date: {
      dateMath: `${ELASTICSEARCH_DOCS}common-options.html#date-math`,
      dateMathIndexNames: `${ELASTICSEARCH_DOCS}date-math-index-names.html`
    },
    management: {
      dashboardSettings: `${KIBANA_DOCS}advanced-options.html#kibana-dashboard-settings`,
      indexManagement: isServerless ? `${SERVERLESS_DOCS}index-management` : `${ELASTICSEARCH_DOCS}index-mgmt.html`,
      kibanaSearchSettings: `${KIBANA_DOCS}advanced-options.html#kibana-search-settings`,
      discoverSettings: `${KIBANA_DOCS}advanced-options.html#kibana-discover-settings`,
      rollupSettings: `${KIBANA_DOCS}advanced-options.html#kibana-rollups-settings`,
      visualizationSettings: `${KIBANA_DOCS}advanced-options.html#kibana-visualization-settings`,
      timelionSettings: `${KIBANA_DOCS}advanced-options.html#kibana-timelion-settings`,
      savedObjectsApiList: `${KIBANA_DOCS}saved-objects-api.html#saved-objects-api`
    },
    ml: {
      guide: `${MACHINE_LEARNING_DOCS}index.html`,
      aggregations: `${MACHINE_LEARNING_DOCS}ml-configuring-aggregation.html`,
      anomalyDetection: `${MACHINE_LEARNING_DOCS}ml-ad-overview.html`,
      anomalyDetectionBucketSpan: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-bucket-span`,
      anomalyDetectionConfiguringCategories: `${MACHINE_LEARNING_DOCS}ml-configuring-categories.html`,
      anomalyDetectionCardinality: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-cardinality`,
      anomalyDetectionCreateJobs: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-create-job`,
      anomalyDetectionDetectors: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-detectors`,
      anomalyDetectionFunctions: `${MACHINE_LEARNING_DOCS}ml-functions.html`,
      anomalyDetectionInfluencers: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-influencers`,
      anomalyDetectionJobs: `${MACHINE_LEARNING_DOCS}ml-ad-finding-anomalies.html`,
      anomalyDetectionJobResource: `${ELASTICSEARCH_DOCS}ml-put-job.html#ml-put-job-path-parms`,
      anomalyDetectionJobResourceAnalysisConfig: `${ELASTICSEARCH_DOCS}ml-put-job.html#put-analysisconfig`,
      anomalyDetectionJobTips: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-job-tips`,
      anomalyDetectionScoreExplanation: `${MACHINE_LEARNING_DOCS}ml-ad-explain.html`,
      alertingRules: `${MACHINE_LEARNING_DOCS}ml-configuring-alerts.html`,
      anomalyDetectionModelMemoryLimits: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-model-memory-limits`,
      calendars: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-calendars`,
      classificationEvaluation: `${MACHINE_LEARNING_DOCS}ml-dfa-classification.html#ml-dfanalytics-classification-evaluation`,
      customRules: `${MACHINE_LEARNING_DOCS}ml-ad-run-jobs.html#ml-ad-rules`,
      customUrls: `${MACHINE_LEARNING_DOCS}ml-configuring-url.html`,
      dataFrameAnalytics: `${MACHINE_LEARNING_DOCS}ml-dfanalytics.html`,
      dFAPrepareData: `${MACHINE_LEARNING_DOCS}ml-dfa-overview.html#prepare-transform-data`,
      dFAStartJob: `${ELASTICSEARCH_DOCS}start-dfanalytics.html`,
      dFACreateJob: `${ELASTICSEARCH_DOCS}put-dfanalytics.html`,
      featureImportance: `${MACHINE_LEARNING_DOCS}ml-feature-importance.html`,
      outlierDetectionRoc: `${MACHINE_LEARNING_DOCS}ml-dfa-finding-outliers.html#ml-dfanalytics-roc`,
      regressionEvaluation: `${MACHINE_LEARNING_DOCS}ml-dfa-regression.html#ml-dfanalytics-regression-evaluation`,
      classificationAucRoc: `${MACHINE_LEARNING_DOCS}ml-dfa-classification.html#ml-dfanalytics-class-aucroc`,
      setUpgradeMode: `${ELASTICSEARCH_DOCS}ml-set-upgrade-mode.html`,
      trainedModels: `${MACHINE_LEARNING_DOCS}ml-trained-models.html`,
      startTrainedModelsDeployment: `${MACHINE_LEARNING_DOCS}ml-nlp-deploy-model.html`,
      nlpElser: `${MACHINE_LEARNING_DOCS}ml-nlp-elser.html`,
      nlpE5: `${MACHINE_LEARNING_DOCS}ml-nlp-e5.html`,
      nlpImportModel: `${MACHINE_LEARNING_DOCS}ml-nlp-import-model.html`
    },
    transforms: {
      guide: isServerless ? `${SERVERLESS_DOCS}transforms` : `${ELASTICSEARCH_DOCS}transforms.html`,
      alertingRules: `${ELASTICSEARCH_DOCS}transform-alerts.html`
    },
    visualize: {
      guide: `${KIBANA_DOCS}dashboard.html`,
      lens: `${ELASTIC_WEBSITE_URL}what-is/kibana-lens`,
      lensPanels: `${KIBANA_DOCS}lens.html`,
      maps: `${ELASTIC_WEBSITE_URL}maps`,
      vega: `${KIBANA_DOCS}vega.html`,
      tsvbIndexPatternMode: `${KIBANA_DOCS}tsvb.html#tsvb-index-pattern-mode`
    },
    observability: {
      guide: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}what-is-observability-serverless` : `${OBSERVABILITY_DOCS}index.html`,
      infrastructureThreshold: `${OBSERVABILITY_DOCS}infrastructure-threshold-alert.html`,
      logsThreshold: `${OBSERVABILITY_DOCS}logs-threshold-alert.html`,
      metricsThreshold: `${OBSERVABILITY_DOCS}metrics-threshold-alert.html`,
      customThreshold: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-custom-threshold-alert-rule` : `${OBSERVABILITY_DOCS}custom-threshold-alert.html`,
      monitorStatus: `${OBSERVABILITY_DOCS}monitor-status-alert.html`,
      monitorUptime: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}monitor-synthetics` : `${OBSERVABILITY_DOCS}monitor-uptime.html`,
      tlsCertificate: `${OBSERVABILITY_DOCS}tls-certificate-alert.html`,
      uptimeDurationAnomaly: `${OBSERVABILITY_DOCS}duration-anomaly-alert.html`,
      monitorLogs: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}discover-and-explore-logs` : `${OBSERVABILITY_DOCS}monitor-logs.html`,
      analyzeMetrics: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}infrastructure-monitoring` : `${OBSERVABILITY_DOCS}analyze-metrics.html`,
      monitorUptimeSynthetics: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}monitor-synthetics` : `${OBSERVABILITY_DOCS}monitor-uptime-synthetics.html`,
      userExperience: `${OBSERVABILITY_DOCS}user-experience.html`,
      createAlerts: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}alerting` : `${OBSERVABILITY_DOCS}create-alerts.html`,
      syntheticsAlerting: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}synthetics-settings#alerting` : `${OBSERVABILITY_DOCS}synthetics-settings.html#synthetics-settings-alerting`,
      syntheticsCommandReference: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}synthetics-configuration#playwrightoptions` : `${OBSERVABILITY_DOCS}synthetics-configuration.html#synthetics-configuration-playwright-options`,
      syntheticsProjectMonitors: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}synthetics-get-started-project` : `${OBSERVABILITY_DOCS}synthetic-run-tests.html#synthetic-monitor-choose-project`,
      syntheticsMigrateFromIntegration: `${OBSERVABILITY_DOCS}synthetics-migrate-from-integration.html`,
      sloBurnRateRule: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-slo-burn-rate-alert-rule` : `${OBSERVABILITY_DOCS}slo-burn-rate-alert.html`,
      aiAssistant: `${OBSERVABILITY_DOCS}obs-ai-assistant.html`
    },
    alerting: {
      guide: isServerless ? `${SERVERLESS_DOCS}rules` : `${KIBANA_DOCS}create-and-manage-rules.html`,
      actionTypes: isServerless ? `${SERVERLESS_DOCS}action-connectors` : `${KIBANA_DOCS}action-types.html`,
      apmRulesErrorCount: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-error-count-threshold-alert-rule` : `${KIBANA_DOCS}apm-alerts.html`,
      apmRulesTransactionDuration: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-latency-threshold-alert-rule` : `${KIBANA_DOCS}apm-alerts.html`,
      apmRulesTransactionError: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-failed-transaction-rate-threshold-alert-rule` : `${KIBANA_DOCS}apm-alerts.html`,
      apmRulesAnomaly: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}create-anomaly-alert-rule` : `${KIBANA_DOCS}apm-alerts.html`,
      emailAction: `${KIBANA_DOCS}email-action-type.html`,
      emailActionConfig: `${KIBANA_DOCS}email-action-type.html`,
      emailExchangeClientSecretConfig: `${KIBANA_DOCS}email-action-type.html#exchange-client-secret`,
      emailExchangeClientIdConfig: `${KIBANA_DOCS}email-action-type.html#exchange-client-tenant-id`,
      generalSettings: `${KIBANA_DOCS}alert-action-settings-kb.html#general-alert-action-settings`,
      indexAction: `${KIBANA_DOCS}index-action-type.html`,
      esQuery: `${KIBANA_DOCS}rule-type-es-query.html`,
      indexThreshold: `${KIBANA_DOCS}rule-type-index-threshold.html`,
      maintenanceWindows: isServerless ? `${SERVERLESS_DOCS}maintenance-windows` : `${KIBANA_DOCS}maintenance-windows.html`,
      pagerDutyAction: `${KIBANA_DOCS}pagerduty-action-type.html`,
      preconfiguredConnectors: `${KIBANA_DOCS}pre-configured-connectors.html`,
      preconfiguredAlertHistoryConnector: `${KIBANA_DOCS}pre-configured-connectors.html#preconfigured-connector-alert-history`,
      serviceNowAction: `${KIBANA_DOCS}servicenow-action-type.html#configuring-servicenow`,
      serviceNowSIRAction: `${KIBANA_DOCS}servicenow-sir-action-type.html`,
      setupPrerequisites: `${KIBANA_DOCS}alerting-setup.html#alerting-prerequisites`,
      slackAction: `${KIBANA_DOCS}slack-action-type.html#configuring-slack-webhook`,
      slackApiAction: `${KIBANA_DOCS}slack-action-type.html#configuring-slack-web-api`,
      teamsAction: `${KIBANA_DOCS}teams-action-type.html#configuring-teams`,
      connectors: `${KIBANA_DOCS}action-types.html`
    },
    taskManager: {
      healthMonitoring: `${KIBANA_DOCS}task-manager-health-monitoring.html`
    },
    maps: {
      connectToEms: `${KIBANA_DOCS}maps-connect-to-ems.html`,
      guide: isServerless ? `${SERVERLESS_DOCS}maps` : `${KIBANA_DOCS}maps.html`,
      importGeospatialPrivileges: `${KIBANA_DOCS}import-geospatial-data.html#import-geospatial-privileges`,
      gdalTutorial: `${ELASTIC_WEBSITE_URL}blog/how-to-ingest-geospatial-data-into-elasticsearch-with-gdal`,
      termJoinsExample: `${KIBANA_DOCS}terms-join.html#_example_term_join`
    },
    monitoring: {
      alertsKibana: `${KIBANA_DOCS}kibana-alerts.html`,
      alertsKibanaCpuThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-cpu-threshold`,
      alertsKibanaDiskThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-disk-usage-threshold`,
      alertsKibanaJvmThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-jvm-memory-threshold`,
      alertsKibanaMissingData: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-missing-monitoring-data`,
      alertsKibanaThreadpoolRejections: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-thread-pool-rejections`,
      alertsKibanaCCRReadExceptions: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-ccr-read-exceptions`,
      alertsKibanaLargeShardSize: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-large-shard-size`,
      alertsKibanaClusterAlerts: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-cluster-alerts`,
      metricbeatBlog: `${ELASTIC_WEBSITE_URL}blog/external-collection-for-elastic-stack-monitoring-is-now-available-via-metricbeat`,
      monitorElasticsearch: `${ELASTICSEARCH_DOCS}configuring-metricbeat.html`,
      monitorKibana: `${KIBANA_DOCS}monitoring-metricbeat.html`,
      monitorLogstash: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}/monitoring-with-metricbeat.html`,
      troubleshootKibana: `${KIBANA_DOCS}monitor-troubleshooting.html`
    },
    reporting: {
      cloudMinimumRequirements: `${KIBANA_DOCS}reporting-getting-started.html#reporting-on-cloud-resource-requirements`,
      grantUserAccess: `${KIBANA_DOCS}secure-reporting.html#grant-user-access`,
      browserSystemDependencies: `${KIBANA_DOCS}secure-reporting.html#install-reporting-packages`,
      browserSandboxDependencies: `${KIBANA_DOCS}reporting-troubleshooting-pdf.html#reporting-troubleshooting-sandbox-dependency`
    },
    security: {
      apiKeyServiceSettings: `${ELASTICSEARCH_DOCS}security-settings.html#api-key-service-settings`,
      clusterPrivileges: `${ELASTICSEARCH_DOCS}security-privileges.html#privileges-list-cluster`,
      definingRoles: `${ELASTICSEARCH_DOCS}defining-roles.html`,
      elasticsearchSettings: `${ELASTICSEARCH_DOCS}security-settings.html`,
      elasticsearchEnableSecurity: `${ELASTICSEARCH_DOCS}configuring-stack-security.html`,
      elasticsearchEnableApiKeys: `${ELASTICSEARCH_DOCS}security-settings.html#api-key-service-settings`,
      indicesPrivileges: `${ELASTICSEARCH_DOCS}security-privileges.html#privileges-list-indices`,
      kibanaTLS: `${ELASTICSEARCH_DOCS}security-basic-setup.html#encrypt-internode-communication`,
      kibanaPrivileges: `${KIBANA_DOCS}kibana-privileges.html`,
      mappingRoles: `${ELASTICSEARCH_DOCS}mapping-roles.html`,
      mappingRolesFieldRules: `${ELASTICSEARCH_DOCS}role-mapping-resources.html#mapping-roles-rule-field`,
      runAsPrivilege: `${ELASTICSEARCH_DOCS}security-privileges.html#_run_as_privilege`
    },
    spaces: {
      kibanaLegacyUrlAliases: `${KIBANA_DOCS}legacy-url-aliases.html`,
      kibanaDisableLegacyUrlAliasesApi: `${KIBANA_DOCS}spaces-api-disable-legacy-url-aliases.html`
    },
    watcher: {
      jiraAction: `${ELASTICSEARCH_DOCS}actions-jira.html`,
      pagerDutyAction: `${ELASTICSEARCH_DOCS}actions-pagerduty.html`,
      slackAction: `${ELASTICSEARCH_DOCS}actions-slack.html`,
      ui: `${KIBANA_DOCS}watcher-ui.html`
    },
    ccs: {
      guide: `${ELASTICSEARCH_DOCS}modules-cross-cluster-search.html`,
      skippingDisconnectedClusters: `${ELASTICSEARCH_DOCS}modules-cross-cluster-search.html#skip-unavailable-clusters`
    },
    apis: {
      bulkIndexAlias: `${ELASTICSEARCH_DOCS}indices-aliases.html`,
      indexStats: `${ELASTICSEARCH_DOCS}indices-stats.html`,
      byteSizeUnits: `${ELASTICSEARCH_DOCS}api-conventions.html#byte-units`,
      createAutoFollowPattern: `${ELASTICSEARCH_DOCS}ccr-put-auto-follow-pattern.html`,
      createFollower: `${ELASTICSEARCH_DOCS}ccr-put-follow.html`,
      createIndex: `${ELASTICSEARCH_DOCS}indices-create-index.html`,
      createSnapshotLifecyclePolicy: `${ELASTICSEARCH_DOCS}slm-api-put-policy.html`,
      createRoleMapping: `${ELASTICSEARCH_DOCS}security-api-put-role-mapping.html`,
      createRoleMappingTemplates: `${ELASTICSEARCH_DOCS}security-api-put-role-mapping.html#_role_templates`,
      createRollupJobsRequest: `${ELASTICSEARCH_DOCS}rollup-put-job.html#rollup-put-job-api-request-body`,
      createApiKey: `${ELASTICSEARCH_DOCS}security-api-create-api-key.html`,
      createPipeline: `${ELASTICSEARCH_DOCS}put-pipeline-api.html`,
      createTransformRequest: `${ELASTICSEARCH_DOCS}put-transform.html#put-transform-request-body`,
      cronExpressions: `${ELASTICSEARCH_DOCS}cron-expressions.html`,
      executeWatchActionModes: `${ELASTICSEARCH_DOCS}watcher-api-execute-watch.html#watcher-api-execute-watch-action-mode`,
      indexExists: `${ELASTICSEARCH_DOCS}indices-exists.html`,
      inferTrainedModel: `${ELASTICSEARCH_DOCS}infer-trained-model.html`,
      multiSearch: `${ELASTICSEARCH_DOCS}search-multi-search.html`,
      openIndex: `${ELASTICSEARCH_DOCS}indices-open-close.html`,
      putComponentTemplate: `${ELASTICSEARCH_DOCS}indices-component-template.html`,
      painlessExecute: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-execute-api.html`,
      painlessExecuteAPIContexts: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-execute-api.html#_contexts`,
      putComponentTemplateMetadata: `${ELASTICSEARCH_DOCS}indices-component-template.html#component-templates-metadata`,
      putEnrichPolicy: `${ELASTICSEARCH_DOCS}put-enrich-policy-api.html`,
      putIndexTemplateV1: `${ELASTICSEARCH_DOCS}indices-templates-v1.html`,
      putSnapshotLifecyclePolicy: `${ELASTICSEARCH_DOCS}slm-api-put-policy.html`,
      putWatch: `${ELASTICSEARCH_DOCS}watcher-api-put-watch.html`,
      restApis: `${ELASTICSEARCH_DOCS}rest-apis.html`,
      searchPreference: `${ELASTICSEARCH_DOCS}search-search.html#search-preference`,
      securityApis: `${ELASTICSEARCH_DOCS}security-api.html`,
      simulatePipeline: `${ELASTICSEARCH_DOCS}simulate-pipeline-api.html`,
      tasks: `${ELASTICSEARCH_DOCS}tasks.html`,
      timeUnits: `${ELASTICSEARCH_DOCS}api-conventions.html#time-units`,
      unfreezeIndex: `${ELASTICSEARCH_DOCS}unfreeze-index-api.html`,
      updateTransform: `${ELASTICSEARCH_DOCS}update-transform.html`
    },
    plugins: {
      azureRepo: `${ELASTICSEARCH_DOCS}repository-azure.html`,
      gcsRepo: `${ELASTICSEARCH_DOCS}repository-gcs.html`,
      hdfsRepo: `${PLUGIN_DOCS}repository-hdfs.html`,
      ingestAttachment: `${PLUGIN_DOCS}ingest-attachment.html`,
      s3Repo: `${ELASTICSEARCH_DOCS}repository-s3.html`,
      snapshotRestoreRepos: `${ELASTICSEARCH_DOCS}snapshots-register-repository.html`,
      mapperSize: `${PLUGIN_DOCS}mapper-size-usage.html`
    },
    snapshotRestore: {
      guide: `${ELASTICSEARCH_DOCS}snapshot-restore.html`,
      changeIndexSettings: `${ELASTICSEARCH_DOCS}index-modules.html`,
      createSnapshot: `${ELASTICSEARCH_DOCS}snapshots-take-snapshot.html`,
      getSnapshot: `${ELASTICSEARCH_DOCS}get-snapshot-api.html`,
      registerSharedFileSystem: `${ELASTICSEARCH_DOCS}snapshots-filesystem-repository.html#filesystem-repository-settings`,
      registerSourceOnly: `${ELASTICSEARCH_DOCS}snapshots-source-only-repository.html#source-only-repository-settings`,
      registerUrl: `${ELASTICSEARCH_DOCS}snapshots-read-only-repository.html#read-only-url-repository-settings`,
      restoreSnapshot: `${ELASTICSEARCH_DOCS}snapshots-restore-snapshot.html`,
      restoreSnapshotApi: `${ELASTICSEARCH_DOCS}restore-snapshot-api.html#restore-snapshot-api-request-body`,
      searchableSnapshotSharedCache: `${ELASTICSEARCH_DOCS}searchable-snapshots.html#searchable-snapshots-shared-cache`
    },
    ingest: {
      append: `${ELASTICSEARCH_DOCS}append-processor.html`,
      bytes: `${ELASTICSEARCH_DOCS}bytes-processor.html`,
      circle: `${ELASTICSEARCH_DOCS}ingest-circle-processor.html`,
      convert: `${ELASTICSEARCH_DOCS}convert-processor.html`,
      csv: `${ELASTICSEARCH_DOCS}csv-processor.html`,
      date: `${ELASTICSEARCH_DOCS}date-processor.html`,
      dateIndexName: `${ELASTICSEARCH_DOCS}date-index-name-processor.html`,
      dissect: `${ELASTICSEARCH_DOCS}dissect-processor.html`,
      dissectKeyModifiers: `${ELASTICSEARCH_DOCS}dissect-processor.html#dissect-key-modifiers`,
      dotExpander: `${ELASTICSEARCH_DOCS}dot-expand-processor.html`,
      drop: `${ELASTICSEARCH_DOCS}drop-processor.html`,
      enrich: `${ELASTICSEARCH_DOCS}ingest-enriching-data.html`,
      fail: `${ELASTICSEARCH_DOCS}fail-processor.html`,
      foreach: `${ELASTICSEARCH_DOCS}foreach-processor.html`,
      geoIp: `${ELASTICSEARCH_DOCS}geoip-processor.html`,
      geoMatch: `${ELASTICSEARCH_DOCS}geo-match-enrich-policy-type.html`,
      grok: `${ELASTICSEARCH_DOCS}grok-processor.html`,
      gsub: `${ELASTICSEARCH_DOCS}gsub-processor.html`,
      htmlString: `${ELASTICSEARCH_DOCS}htmlstrip-processor.html`,
      inference: `${ELASTICSEARCH_DOCS}inference-processor.html`,
      inferenceClassification: `${ELASTICSEARCH_DOCS}inference-processor.html#inference-processor-classification-opt`,
      inferenceRegression: `${ELASTICSEARCH_DOCS}inference-processor.html#inference-processor-regression-opt`,
      join: `${ELASTICSEARCH_DOCS}join-processor.html`,
      json: `${ELASTICSEARCH_DOCS}json-processor.html`,
      kv: `${ELASTICSEARCH_DOCS}kv-processor.html`,
      lowercase: `${ELASTICSEARCH_DOCS}lowercase-processor.html`,
      pipeline: `${ELASTICSEARCH_DOCS}pipeline-processor.html`,
      pipelines: isServerless ? `${SERVERLESS_DOCS}ingest-pipelines` : `${ELASTICSEARCH_DOCS}ingest.html`,
      csvPipelines: `${ELASTIC_WEBSITE_URL}guide/en/ecs/${ECS_VERSION}/ecs-converting.html`,
      pipelineFailure: `${ELASTICSEARCH_DOCS}ingest.html#handling-pipeline-failures`,
      processors: `${ELASTICSEARCH_DOCS}processors.html`,
      arrayOrJson: `${ELASTICSEARCH_DOCS}processors.html#ingest-process-category-array-json-handling`,
      dataEnrichment: `${ELASTICSEARCH_DOCS}processors.html#ingest-process-category-data-enrichment`,
      dataFiltering: `${ELASTICSEARCH_DOCS}processors.html#ingest-process-category-data-filtering`,
      dataTransformation: `${ELASTICSEARCH_DOCS}processors.html#ingest-process-category-data-transformation`,
      pipelineHandling: `${ELASTICSEARCH_DOCS}processors.html#ingest-process-category-pipeline-handling`,
      remove: `${ELASTICSEARCH_DOCS}remove-processor.html`,
      rename: `${ELASTICSEARCH_DOCS}rename-processor.html`,
      script: `${ELASTICSEARCH_DOCS}script-processor.html`,
      set: `${ELASTICSEARCH_DOCS}set-processor.html`,
      setSecurityUser: `${ELASTICSEARCH_DOCS}ingest-node-set-security-user-processor.html`,
      sort: `${ELASTICSEARCH_DOCS}sort-processor.html`,
      split: `${ELASTICSEARCH_DOCS}split-processor.html`,
      trim: `${ELASTICSEARCH_DOCS}trim-processor.html`,
      uppercase: `${ELASTICSEARCH_DOCS}uppercase-processor.html`,
      uriParts: `${ELASTICSEARCH_DOCS}uri-parts-processor.html`,
      urlDecode: `${ELASTICSEARCH_DOCS}urldecode-processor.html`,
      userAgent: `${ELASTICSEARCH_DOCS}user-agent-processor.html`
    },
    fleet: {
      guide: `${FLEET_DOCS}index.html`,
      fleetServer: `${FLEET_DOCS}fleet-server.html`,
      fleetServerAddFleetServer: `${FLEET_DOCS}add-a-fleet-server.html`,
      settings: `${FLEET_DOCS}fleet-settings.html`,
      kafkaSettings: `${FLEET_DOCS}kafka-output-settings.html`,
      logstashSettings: `${FLEET_DOCS}ls-output-settings.html`,
      esSettings: `${FLEET_DOCS}es-output-settings.html`,
      settingsFleetServerHostSettings: `${FLEET_DOCS}fleet-settings.html#fleet-server-hosts-setting`,
      settingsFleetServerProxySettings: `${KIBANA_DOCS}fleet-settings-kb.html#fleet-data-visualizer-settings`,
      troubleshooting: `${FLEET_DOCS}fleet-troubleshooting.html`,
      elasticAgent: `${FLEET_DOCS}elastic-agent-installation.html`,
      beatsAgentComparison: `${FLEET_DOCS}beats-agent-comparison.html`,
      datastreams: `${FLEET_DOCS}data-streams.html`,
      datastreamsILM: `${FLEET_DOCS}data-streams.html#data-streams-ilm`,
      datastreamsNamingScheme: `${FLEET_DOCS}data-streams.html#data-streams-naming-scheme`,
      datastreamsManualRollover: `${ELASTICSEARCH_DOCS}use-a-data-stream.html#manually-roll-over-a-data-stream`,
      datastreamsTSDS: `${ELASTICSEARCH_DOCS}tsds.html`,
      datastreamsTSDSMetrics: `${ELASTICSEARCH_DOCS}tsds.html#time-series-metric`,
      datastreamsDownsampling: `${ELASTICSEARCH_DOCS}downsampling.html`,
      installElasticAgent: `${FLEET_DOCS}install-fleet-managed-elastic-agent.html`,
      installElasticAgentStandalone: `${FLEET_DOCS}install-standalone-elastic-agent.html`,
      grantESAccessToStandaloneAgents: `${FLEET_DOCS}grant-access-to-elasticsearch.html`,
      upgradeElasticAgent: `${FLEET_DOCS}upgrade-elastic-agent.html`,
      learnMoreBlog: `${ELASTIC_WEBSITE_URL}blog/elastic-agent-and-fleet-make-it-easier-to-integrate-your-systems-with-elastic`,
      apiKeysLearnMore: isServerless ? `${SERVERLESS_DOCS}api-keys` : `${KIBANA_DOCS}api-keys.html`,
      onPremRegistry: `${FLEET_DOCS}air-gapped.html`,
      packageSignatures: `${FLEET_DOCS}package-signatures.html`,
      secureLogstash: `${FLEET_DOCS}secure-logstash-connections.html`,
      agentPolicy: `${FLEET_DOCS}agent-policy.html`,
      api: `${FLEET_DOCS}fleet-api-docs.html`,
      uninstallAgent: `${SECURITY_SOLUTION_DOCS}uninstall-agent.html`,
      installAndUninstallIntegrationAssets: `${FLEET_DOCS}install-uninstall-integration-assets.html`,
      elasticAgentInputConfiguration: `${FLEET_DOCS}elastic-agent-input-configuration.html`,
      policySecrets: `${FLEET_DOCS}agent-policy.html#agent-policy-secret-values`,
      remoteESOoutput: `${FLEET_DOCS}monitor-elastic-agent.html#external-elasticsearch-monitoring`,
      performancePresets: `${FLEET_DOCS}es-output-settings.html#es-output-settings-performance-tuning-settings`,
      scalingKubernetesResourcesAndLimits: `${FLEET_DOCS}scaling-on-kubernetes.html#_specifying_resources_and_limits_in_agent_manifests`,
      roleAndPrivileges: `${FLEET_DOCS}fleet-roles-and-privileges.html`,
      proxiesSettings: `${FLEET_DOCS}fleet-agent-proxy-support.html`,
      unprivilegedMode: `${FLEET_DOCS}elastic-agent-unprivileged.html#unprivileged-change-mode`
    },
    integrationDeveloper: {
      upload: `${INTEGRATIONS_DEV_DOCS}upload-a-new-integration.html`
    },
    ecs: {
      guide: `${ELASTIC_WEBSITE_URL}guide/en/ecs/${ECS_VERSION}/index.html`,
      dataStreams: `${ELASTIC_WEBSITE_URL}guide/en/ecs/${ECS_VERSION}/ecs-data_stream.html`
    },
    clients: {
      /** Changes to these URLs must also be synched in src/plugins/custom_integrations/server/language_clients/index.ts */
      guide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/index.html`,
      goConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/connecting.html`,
      goGettingStarted: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/getting-started-go.html`,
      goIndex: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/index.html`,
      goOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/overview.html`,
      javaBasicAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/_basic_authentication.html`,
      javaIndex: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/index.html`,
      javaInstallation: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/installation.html`,
      javaIntroduction: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/introduction.html`,
      javaRestLow: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/java-rest-low.html`,
      jsAdvancedConfig: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/advanced-config.html`,
      jsApiReference: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/api-reference.html`,
      jsBasicConfig: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/basic-config.html`,
      jsClientConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/client-connecting.html`,
      jsIntro: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/introduction.html`,
      netGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/index.html`,
      netIntroduction: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/introduction.html`,
      netNest: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/nest.html`,
      netSingleNode: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/connecting.html#single-node`,
      phpConfiguration: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/configuration.html`,
      phpConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/connecting.html`,
      phpInstallation: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/installation.html`,
      phpGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/index.html`,
      phpOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/overview.html`,
      pythonAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/connecting.html#authentication`,
      pythonConfig: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/config.html`,
      pythonConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/connecting.html`,
      pythonGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/index.html`,
      pythonOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/overview.html`,
      rubyAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/connecting.html#client-auth`,
      rubyAdvancedConfig: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/advanced-config.html`,
      rubyBasicConfig: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/basic-config.html`,
      rubyExamples: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/examples.html`,
      rubyOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/ruby_client.html`,
      rustGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/rust-api/${DOC_LINK_VERSION}/index.html`,
      rustOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/rust-api/${DOC_LINK_VERSION}/overview.html`,
      eland: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/eland/current/index.html`
    },
    endpoints: {
      troubleshooting: `${SECURITY_SOLUTION_DOCS}ts-management.html#ts-endpoints`
    },
    legal: {
      privacyStatement: `${ELASTIC_WEBSITE_URL}legal/product-privacy-statement`,
      generalPrivacyStatement: `${ELASTIC_WEBSITE_URL}legal/privacy-statement`,
      termsOfService: `${ELASTIC_WEBSITE_URL}legal/elastic-cloud-account-terms`,
      dataUse: `${ELASTIC_WEBSITE_URL}legal/privacy-statement#how-we-use-the-information`
    },
    kibanaUpgradeSavedObjects: {
      resolveMigrationFailures: `${KIBANA_DOCS}resolve-migrations-failures.html`,
      repeatedTimeoutRequests: `${KIBANA_DOCS}resolve-migrations-failures.html#_repeated_time_out_requests_that_eventually_fail`,
      routingAllocationDisabled: `${KIBANA_DOCS}resolve-migrations-failures.html#routing-allocation-disabled`,
      clusterShardLimitExceeded: `${KIBANA_DOCS}resolve-migrations-failures.html#cluster-shard-limit-exceeded`
    },
    searchUI: {
      appSearch: `${SEARCH_UI_DOCS}tutorials/app-search`,
      elasticsearch: `${SEARCH_UI_DOCS}tutorials/elasticsearch`
    },
    serverlessClients: {
      clientLib: `${SERVERLESS_ELASTICSEARCH_DOCS}clients`,
      goApiReference: `${SERVERLESS_ELASTICSEARCH_DOCS}go-client-getting-started`,
      goGettingStarted: `${SERVERLESS_ELASTICSEARCH_DOCS}go-client-getting-started`,
      httpApis: `${SERVERLESS_ELASTICSEARCH_DOCS}http-apis`,
      httpApiReferences: `${SERVERLESS_ELASTICSEARCH_DOCS}http-apis`,
      jsApiReference: `${SERVERLESS_ELASTICSEARCH_DOCS}nodejs-client-getting-started`,
      jsGettingStarted: `${SERVERLESS_ELASTICSEARCH_DOCS}nodejs-client-getting-started`,
      phpApiReference: `${SERVERLESS_ELASTICSEARCH_DOCS}php-client-getting-started`,
      phpGettingStarted: `${SERVERLESS_ELASTICSEARCH_DOCS}php-client-getting-started`,
      pythonApiReference: `${SERVERLESS_ELASTICSEARCH_DOCS}python-client-getting-started`,
      pythonGettingStarted: `${SERVERLESS_ELASTICSEARCH_DOCS}python-client-getting-started`,
      pythonReferences: `${SERVERLESS_ELASTICSEARCH_DOCS}python-client-getting-started`,
      rubyApiReference: `${SERVERLESS_ELASTICSEARCH_DOCS}ruby-client-getting-started`,
      rubyGettingStarted: `${SERVERLESS_ELASTICSEARCH_DOCS}ruby-client-getting-started`
    },
    serverlessSearch: {
      integrations: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-your-data`,
      integrationsLogstash: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-logstash`,
      integrationsBeats: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-beats`,
      integrationsConnectorClient: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-integrations-connector-client`,
      integrationsConnectorClientAvailableConnectors: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-integrations-connector-client#available-connectors`,
      integrationsConnectorClientRunFromSource: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-integrations-connector-client#run-from-source`,
      integrationsConnectorClientRunWithDocker: `${SERVERLESS_ELASTICSEARCH_DOCS}ingest-data-through-integrations-connector-client#run-with-docker`,
      gettingStartedExplore: `${SERVERLESS_ELASTICSEARCH_DOCS}get-started`,
      gettingStartedIngest: `${SERVERLESS_ELASTICSEARCH_DOCS}get-started`,
      gettingStartedSearch: `${SERVERLESS_ELASTICSEARCH_DOCS}get-started`
    },
    serverlessSecurity: {
      apiKeyPrivileges: `${SERVERLESS_DOCS}api-keys#restrict-privileges`
    },
    synthetics: {
      featureRoles: isServerless ? `${SERVERLESS_OBSERVABILITY_DOCS}synthetics-feature-roles` : `${OBSERVABILITY_DOCS}synthetics-feature-roles.html`
    },
    telemetry: {
      settings: `${KIBANA_DOCS}telemetry-settings-kbn.html`
    },
    playground: {
      chatPlayground: `${KIBANA_DOCS}playground.html`,
      retrievalOptimize: `${KIBANA_DOCS}playground-query.html#playground-query-relevance`,
      retrieval: `${KIBANA_DOCS}playground-query.html`,
      context: `${KIBANA_DOCS}playground-context.html`,
      hiddenFields: `${KIBANA_DOCS}playground-query.html#playground-hidden-fields`
    }
  });
};
exports.getDocLinks = getDocLinks;