"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_ID_FIELD = exports.TIMESTAMP_FIELD = exports.SERVICE_NAME_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.MESSAGE_FIELD = exports.LOG_LEVEL_FIELD = exports.LOG_FILE_PATH_FIELD = exports.HOST_NAME_FIELD = exports.EVENT_ORIGINAL_FIELD = exports.ERROR_STACK_TRACE = exports.ERROR_MESSAGE_FIELD = exports.ERROR_LOG_STACKTRACE = exports.ERROR_EXCEPTION_STACKTRACE = exports.DEGRADED_DOCS_FIELD = exports.DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_DATASET_FIELD = exports.CONTAINER_NAME_FIELD = exports.CONTAINER_ID_FIELD = exports.CLOUD_REGION_FIELD = exports.CLOUD_PROVIDER_FIELD = exports.CLOUD_PROJECT_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = exports.AGENT_NAME_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Fields constants
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const HOST_NAME_FIELD = exports.HOST_NAME_FIELD = 'host.name';
const LOG_LEVEL_FIELD = exports.LOG_LEVEL_FIELD = 'log.level';
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const ERROR_MESSAGE_FIELD = exports.ERROR_MESSAGE_FIELD = 'error.message';
const EVENT_ORIGINAL_FIELD = exports.EVENT_ORIGINAL_FIELD = 'event.original';
const TRACE_ID_FIELD = exports.TRACE_ID_FIELD = 'trace.id';
const LOG_FILE_PATH_FIELD = exports.LOG_FILE_PATH_FIELD = 'log.file.path';
const DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_NAMESPACE_FIELD = 'data_stream.namespace';
const DATASTREAM_DATASET_FIELD = exports.DATASTREAM_DATASET_FIELD = 'data_stream.dataset';

// Resource Fields
const AGENT_NAME_FIELD = exports.AGENT_NAME_FIELD = 'agent.name';
const CLOUD_PROVIDER_FIELD = exports.CLOUD_PROVIDER_FIELD = 'cloud.provider';
const CLOUD_REGION_FIELD = exports.CLOUD_REGION_FIELD = 'cloud.region';
const CLOUD_AVAILABILITY_ZONE_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = 'cloud.availability_zone';
const CLOUD_PROJECT_ID_FIELD = exports.CLOUD_PROJECT_ID_FIELD = 'cloud.project.id';
const CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = 'cloud.instance.id';
const SERVICE_NAME_FIELD = exports.SERVICE_NAME_FIELD = 'service.name';
const ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = 'orchestrator.cluster.name';
const ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = 'orchestrator.resource.id';
const ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = 'orchestrator.namespace';
const CONTAINER_NAME_FIELD = exports.CONTAINER_NAME_FIELD = 'container.name';
const CONTAINER_ID_FIELD = exports.CONTAINER_ID_FIELD = 'container.id';

// Degraded Docs
const DEGRADED_DOCS_FIELD = exports.DEGRADED_DOCS_FIELD = 'ignored_field_values';

// Error Stacktrace
const ERROR_STACK_TRACE = exports.ERROR_STACK_TRACE = 'error.stack_trace';
const ERROR_EXCEPTION_STACKTRACE = exports.ERROR_EXCEPTION_STACKTRACE = 'error.exception.stacktrace';
const ERROR_LOG_STACKTRACE = exports.ERROR_LOG_STACKTRACE = 'error.log.stacktrace';