"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsContextService = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = void 0;
var _dataViewUtils = require("@kbn/data-view-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

const DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = ['log', 'logs', 'logstash', 'auditbeat', 'filebeat', 'winlogbeat'];
const createLogsContextService = (_deps = {}) => {
  // This is initially an hard-coded set of well-known base patterns,
  // we can extend this allowed list with any setting coming from uiSettings
  const ALLOWED_LOGS_DATA_SOURCES = [(0, _dataViewUtils.createRegExpPatternFrom)(DEFAULT_ALLOWED_LOGS_BASE_PATTERNS)];
  const isLogsIndexPattern = indexPattern => {
    return typeof indexPattern === 'string' && (0, _dataViewUtils.testPatternAgainstAllowedList)(ALLOWED_LOGS_DATA_SOURCES)(indexPattern);
  };
  return {
    isLogsIndexPattern
  };
};
exports.createLogsContextService = createLogsContextService;