"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filtersFromLocatorFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */
const filtersFromLocatorFactory = services => {
  /**
   * @public
   */
  const filtersFromLocator = async params => {
    var _params$dataViewSpec;
    const filters = [];
    if (params.timeRange && (_params$dataViewSpec = params.dataViewSpec) !== null && _params$dataViewSpec !== void 0 && _params$dataViewSpec.timeFieldName) {
      const timeRange = params.timeRange;
      const timeFieldName = params.dataViewSpec.timeFieldName;
      if (timeRange) {
        filters.push({
          meta: {},
          query: {
            range: {
              [timeFieldName]: {
                format: 'strict_date_optional_time',
                gte: timeRange.from,
                lte: timeRange.to
              }
            }
          }
        });
      }
    }
    if (params.filters) {
      filters.push(...params.filters);
    }
    return filters;

    // TODO: support extracting filters from saved search
  };
  return filtersFromLocator;
};
exports.filtersFromLocatorFactory = filtersFromLocatorFactory;