"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setBreadcrumbs = setBreadcrumbs;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const rootPath = '#/';
function getRootBreadcrumbs({
  breadcrumb
}) {
  return [{
    text: _i18n.i18n.translate('discover.rootBreadcrumb', {
      defaultMessage: 'Discover'
    }),
    deepLinkId: 'discover',
    href: breadcrumb || rootPath
  }];
}

/**
 * Helper function to set the Discover's breadcrumb
 * if there's an active savedSearch, its title is appended
 */
function setBreadcrumbs({
  rootBreadcrumbPath,
  titleBreadcrumbText,
  services
}) {
  const rootBreadcrumbs = getRootBreadcrumbs({
    breadcrumb: rootBreadcrumbPath
  });
  const discoverBreadcrumbsTitle = _i18n.i18n.translate('discover.discoverBreadcrumbTitle', {
    defaultMessage: 'Discover'
  });
  if (titleBreadcrumbText) {
    services.chrome.setBreadcrumbs([...rootBreadcrumbs, {
      text: titleBreadcrumbText
    }]);
  } else {
    services.chrome.setBreadcrumbs([{
      text: discoverBreadcrumbsTitle
    }]);
  }
}