"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.restoreStateFromSavedSearch = void 0;
var _validate_time = require("../../utils/validate_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const restoreStateFromSavedSearch = ({
  savedSearch,
  timefilter
}) => {
  var _savedSearch$searchSo;
  if (!savedSearch) {
    return;
  }
  const isTimeBased = (_savedSearch$searchSo = savedSearch.searchSource.getField('index')) === null || _savedSearch$searchSo === void 0 ? void 0 : _savedSearch$searchSo.isTimeBased();
  if (!isTimeBased) {
    return;
  }
  if (savedSearch.timeRestore && savedSearch.timeRange && (0, _validate_time.isTimeRangeValid)(savedSearch.timeRange)) {
    timefilter.setTime(savedSearch.timeRange);
  }
  if (savedSearch.timeRestore && savedSearch.refreshInterval && (0, _validate_time.isRefreshIntervalValid)(savedSearch.refreshInterval)) {
    timefilter.setRefreshInterval(savedSearch.refreshInterval);
  }
};
exports.restoreStateFromSavedSearch = restoreStateFromSavedSearch;