"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeature = registerFeature;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerFeature(home) {
  home.featureCatalogue.register({
    id: 'discover',
    title: _i18n.i18n.translate('discover.discoverTitle', {
      defaultMessage: 'Discover'
    }),
    subtitle: _i18n.i18n.translate('discover.discoverSubtitle', {
      defaultMessage: 'Search and find insights.'
    }),
    description: _i18n.i18n.translate('discover.discoverDescription', {
      defaultMessage: 'Interactively explore your data by querying and filtering raw documents.'
    }),
    icon: 'discoverApp',
    path: '/app/discover#/',
    showOnHomePage: false,
    category: 'data',
    solutionId: 'kibana',
    order: 200
  });
}