"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _esqlUtils = require("@kbn/esql-utils");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _lodash = require("lodash");
var _common = require("../common");
var _register_feature = require("./register_feature");
var _build_services = require("./build_services");
var _embeddable = require("./embeddable");
var _view_saved_search_action = require("./embeddable/view_saved_search_action");
var _truncate_styles = require("./utils/truncate_styles");
var _initialize_kbn_url_tracking = require("./utils/initialize_kbn_url_tracking");
var _locator = require("./application/context/services/locator");
var _locator2 = require("./application/doc/locator");
var _customizations = require("./customizations");
var _constants = require("./embeddable/constants");
var _discover_container = require("./components/discover_container");
var _search_provider = require("./global_search/search_provider");
var _history_service = require("./history_service");
var _context_awareness = require("./context_awareness");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Contains Discover, one of the oldest parts of Kibana
 * Discover provides embeddables for Dashboards
 */
class DiscoverPlugin {
  constructor(initializerContext) {
    var _experimental$ruleFor, _experimental$enabled;
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "historyService", new _history_service.HistoryService());
    (0, _defineProperty2.default)(this, "inlineTopNav", new Map([[null, _customizations.defaultCustomizationContext.inlineTopNav]]));
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    (0, _defineProperty2.default)(this, "scopedHistory", void 0);
    (0, _defineProperty2.default)(this, "urlTracker", void 0);
    (0, _defineProperty2.default)(this, "stopUrlTracking", void 0);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "contextLocator", void 0);
    (0, _defineProperty2.default)(this, "singleDocLocator", void 0);
    (0, _defineProperty2.default)(this, "createProfileServices", (0, _lodash.once)(async () => {
      var _this$experimentalFea;
      const {
        registerProfileProviders
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./context_awareness/profile_providers')));
      const rootProfileService = new _context_awareness.RootProfileService();
      const dataSourceProfileService = new _context_awareness.DataSourceProfileService();
      const documentProfileService = new _context_awareness.DocumentProfileService();
      const experimentalProfileIds = (_this$experimentalFea = this.experimentalFeatures.enabledProfiles) !== null && _this$experimentalFea !== void 0 ? _this$experimentalFea : [];
      registerProfileProviders({
        rootProfileService,
        dataSourceProfileService,
        documentProfileService,
        experimentalProfileIds
      });
      return {
        rootProfileService,
        dataSourceProfileService,
        documentProfileService
      };
    }));
    (0, _defineProperty2.default)(this, "getDiscoverServices", (core, plugins, profilesManager) => {
      return (0, _build_services.buildServices)({
        core,
        plugins,
        context: this.initializerContext,
        locator: this.locator,
        contextLocator: this.contextLocator,
        singleDocLocator: this.singleDocLocator,
        history: this.historyService.getHistory(),
        urlTracker: this.urlTracker,
        profilesManager
      });
    });
    this.initializerContext = initializerContext;
    const experimental = this.initializerContext.config.get().experimental;
    this.experimentalFeatures = {
      ruleFormV2Enabled: (_experimental$ruleFor = experimental === null || experimental === void 0 ? void 0 : experimental.ruleFormV2Enabled) !== null && _experimental$ruleFor !== void 0 ? _experimental$ruleFor : false,
      enabledProfiles: (_experimental$enabled = experimental === null || experimental === void 0 ? void 0 : experimental.enabledProfiles) !== null && _experimental$enabled !== void 0 ? _experimental$enabled : []
    };
  }
  setup(core, plugins) {
    const baseUrl = core.http.basePath.prepend('/app/discover');
    if (plugins.share) {
      const useHash = core.uiSettings.get('state:storeInSessionStorage');
      this.locator = plugins.share.url.locators.create(new _common.DiscoverAppLocatorDefinition({
        useHash,
        setStateToKbnUrl: _public2.setStateToKbnUrl
      }));
      this.contextLocator = plugins.share.url.locators.create(new _locator.DiscoverContextAppLocatorDefinition({
        useHash
      }));
      this.singleDocLocator = plugins.share.url.locators.create(new _locator2.DiscoverSingleDocLocatorDefinition());
    }
    if (plugins.globalSearch) {
      const enableESQL = core.uiSettings.get(_esqlUtils.ENABLE_ESQL);
      plugins.globalSearch.registerResultProvider((0, _search_provider.getESQLSearchProvider)(enableESQL, core.getStartServices().then(([{
        application: {
          capabilities
        }
      }]) => capabilities), core.getStartServices().then(deps => {
        const {
          data
        } = deps[1];
        return data;
      }), this.locator));
    }
    const {
      setTrackedUrl,
      restorePreviousUrl,
      stopUrlTracker,
      appMounted,
      appUnMounted,
      setTrackingEnabled
    } = (0, _initialize_kbn_url_tracking.initializeKbnUrlTracking)({
      baseUrl,
      core,
      navLinkUpdater$: this.appStateUpdater,
      plugins,
      getScopedHistory: () => this.scopedHistory
    });
    this.urlTracker = {
      setTrackedUrl,
      restorePreviousUrl,
      setTrackingEnabled
    };
    this.stopUrlTracking = stopUrlTracker;
    core.application.register({
      id: _common.PLUGIN_ID,
      title: 'Discover',
      updater$: this.appStateUpdater,
      order: 1000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      visibleIn: ['globalSearch', 'sideNav', 'kibanaOverview'],
      mount: async params => {
        const [coreStart, discoverStartPlugins] = await core.getStartServices();

        // Store the current scoped history so initializeKbnUrlTracking can access it
        this.scopedHistory = params.history;
        this.historyService.syncHistoryLocations();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = this.scopedHistory.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        const services = (0, _build_services.buildServices)({
          core: coreStart,
          plugins: discoverStartPlugins,
          context: this.initializerContext,
          locator: this.locator,
          contextLocator: this.contextLocator,
          singleDocLocator: this.singleDocLocator,
          history: this.historyService.getHistory(),
          scopedHistory: this.scopedHistory,
          urlTracker: this.urlTracker,
          profilesManager: await this.createProfilesManager(),
          setHeaderActionMenu: params.setHeaderActionMenu
        });

        // make sure the data view list is up to date
        discoverStartPlugins.dataViews.clearCache();

        // FIXME: Temporarily hide overflow-y in Discover app when Field Stats table is shown
        // due to EUI bug https://github.com/elastic/eui/pull/5152
        params.element.classList.add('dscAppWrapper');
        const customizationContext$ = services.chrome.getActiveSolutionNavId$().pipe((0, _rxjs.map)(solutionNavId => {
          var _ref, _this$inlineTopNav$ge;
          return {
            ..._customizations.defaultCustomizationContext,
            solutionNavId,
            inlineTopNav: (_ref = (_this$inlineTopNav$ge = this.inlineTopNav.get(solutionNavId)) !== null && _this$inlineTopNav$ge !== void 0 ? _this$inlineTopNav$ge : this.inlineTopNav.get(null)) !== null && _ref !== void 0 ? _ref : _customizations.defaultCustomizationContext.inlineTopNav
          };
        }));
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const unmount = renderApp({
          element: params.element,
          services,
          customizationContext$,
          experimentalFeatures: this.experimentalFeatures
        });
        return () => {
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    plugins.urlForwarding.forwardApp('doc', 'discover', path => {
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('context', 'discover', path => {
      const urlParts = path.split('/');
      // take care of urls containing legacy url, those split in the following way
      // ["", "context", indexPatternId, _type, id + params]
      if (urlParts[4]) {
        // remove _type part
        const newPath = [...urlParts.slice(0, 3), ...urlParts.slice(4)].join('/');
        return `#${newPath}`;
      }
      return `#${path}`;
    });
    plugins.urlForwarding.forwardApp('discover', 'discover', path => {
      const [, id, tail] = /discover\/([^\?]+)(.*)/.exec(path) || [];
      if (!id) {
        return `#${path.replace('/discover', '') || '/'}`;
      }
      return `#/view/${id}${tail || ''}`;
    });
    if (plugins.home) {
      (0, _register_feature.registerFeature)(plugins.home);
    }
    this.registerEmbeddable(core, plugins);
    return {
      locator: this.locator,
      showInlineTopNav: () => {
        this.inlineTopNav.set(null, {
          enabled: true,
          showLogsExplorerTabs: false
        });
      },
      configureInlineTopNav: (projectNavId, options) => {
        this.inlineTopNav.set(projectNavId, options);
      }
    };
  }
  start(core, plugins) {
    const viewSavedSearchAction = new _view_saved_search_action.ViewSavedSearchAction(core.application, this.locator);
    plugins.uiActions.addTriggerAction('CONTEXT_MENU_TRIGGER', viewSavedSearchAction);
    plugins.uiActions.registerTrigger(_constants.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER);
    (0, _truncate_styles.injectTruncateStyles)(core.uiSettings.get(_discoverUtils.TRUNCATE_MAX_HEIGHT));
    const isEsqlEnabled = core.uiSettings.get(_esqlUtils.ENABLE_ESQL);
    if (plugins.share && this.locator && isEsqlEnabled) {
      var _plugins$share;
      (_plugins$share = plugins.share) === null || _plugins$share === void 0 ? void 0 : _plugins$share.url.locators.create(new _common.DiscoverESQLLocatorDefinition({
        discoverAppLocator: this.locator,
        getIndices: plugins.dataViews.getIndices
      }));
    }
    const getDiscoverServicesInternal = () => {
      return this.getDiscoverServices(core, plugins, this.createEmptyProfilesManager());
    };
    return {
      locator: this.locator,
      DiscoverContainer: props => /*#__PURE__*/_react.default.createElement(_discover_container.DiscoverContainerInternal, (0, _extends2.default)({
        getDiscoverServices: getDiscoverServicesInternal
      }, props))
    };
  }
  stop() {
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
  async createProfilesManager() {
    const {
      rootProfileService,
      dataSourceProfileService,
      documentProfileService
    } = await this.createProfileServices();
    return new _context_awareness.ProfilesManager(rootProfileService, dataSourceProfileService, documentProfileService);
  }
  createEmptyProfilesManager() {
    return new _context_awareness.ProfilesManager(new _context_awareness.RootProfileService(), new _context_awareness.DataSourceProfileService(), new _context_awareness.DocumentProfileService());
  }
  registerEmbeddable(core, plugins) {
    const getStartServices = async () => {
      const [coreStart, deps] = await core.getStartServices();
      return {
        executeTriggerActions: deps.uiActions.executeTriggerActions,
        isEditable: () => coreStart.application.capabilities.discover.save
      };
    };
    const getDiscoverServicesInternal = async () => {
      const [coreStart, deps] = await core.getStartServices();
      const profilesManager = await this.createProfilesManager();
      return this.getDiscoverServices(coreStart, deps, profilesManager);
    };
    const factory = new _embeddable.SearchEmbeddableFactory(getStartServices, getDiscoverServicesInternal);
    plugins.embeddable.registerEmbeddableFactory(factory.type, factory);
  }
}
exports.DiscoverPlugin = DiscoverPlugin;