"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSearchSource = void 0;
var _sorting = require("../../utils/sorting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateSearchSource = (searchSource, dataView, sort, sampleSize, useNewFieldsApi, defaults) => {
  const {
    sortDir
  } = defaults;
  searchSource.setField('size', sampleSize);
  searchSource.setField('sort', (0, _sorting.getSortForSearchSource)({
    sort,
    dataView,
    defaultSortDir: sortDir,
    includeTieBreaker: true
  }));
  if (useNewFieldsApi) {
    searchSource.removeField('fieldsFromSource');
    searchSource.setField('fields', [{
      field: '*',
      include_unmapped: true
    }]);
  } else {
    searchSource.removeField('fields');
  }
};
exports.updateSearchSource = updateSearchSource;