"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchEmbeddableComponent = SavedSearchEmbeddableComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _saved_search_grid = require("./saved_search_grid");
var _create_doc_table_embeddable = require("../components/doc_table/create_doc_table_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverDocTableEmbeddableMemoized = /*#__PURE__*/_react.default.memo(_create_doc_table_embeddable.DiscoverDocTableEmbeddable);
const DiscoverGridEmbeddableMemoized = /*#__PURE__*/_react.default.memo(_saved_search_grid.DiscoverGridEmbeddable);
function SavedSearchEmbeddableComponent({
  fetchedSampleSize,
  searchProps,
  useLegacyTable,
  query
}) {
  if (useLegacyTable) {
    return /*#__PURE__*/_react.default.createElement(DiscoverDocTableEmbeddableMemoized, (0, _extends2.default)({}, searchProps, {
      sampleSizeState: fetchedSampleSize,
      isEsqlMode: (0, _esQuery.isOfAggregateQueryType)(query)
    }));
  }
  return /*#__PURE__*/_react.default.createElement(DiscoverGridEmbeddableMemoized, (0, _extends2.default)({}, searchProps, {
    sampleSizeState: fetchedSampleSize,
    loadingState: searchProps.isLoading ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded,
    query: query
  }));
}