"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverLocatorParams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDiscoverLocatorParams = api => {
  var _api$savedObjectId;
  const savedSearch = api.getSavedSearch();
  const dataView = savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('index');
  const savedObjectId = (_api$savedObjectId = api.savedObjectId) === null || _api$savedObjectId === void 0 ? void 0 : _api$savedObjectId.getValue();
  const locatorParams = savedObjectId ? {
    savedSearchId: savedObjectId
  } : {
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec(),
    timeRange: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.timeRange,
    refreshInterval: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.refreshInterval,
    filters: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('filter'),
    query: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource.getField('query'),
    columns: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.columns,
    sort: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.sort,
    viewMode: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.viewMode,
    hideAggregatedPreview: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.hideAggregatedPreview,
    breakdownField: savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.breakdownField
  };
  return locatorParams;
};
exports.getDiscoverLocatorParams = getDiscoverLocatorParams;