"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileService = exports.BaseProfileService = exports.AsyncProfileService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable max-classes-per-file */

const EMPTY_PROFILE = {};
class BaseProfileService {
  constructor(defaultContext) {
    (0, _defineProperty2.default)(this, "providers", []);
    this.defaultContext = defaultContext;
  }
  registerProvider(provider) {
    this.providers.push(provider);
  }
  getProfile(context) {
    var _provider$profile;
    const provider = this.providers.find(current => current.profileId === context.profileId);
    return (_provider$profile = provider === null || provider === void 0 ? void 0 : provider.profile) !== null && _provider$profile !== void 0 ? _provider$profile : EMPTY_PROFILE;
  }
}
exports.BaseProfileService = BaseProfileService;
class ProfileService extends BaseProfileService {
  resolve(params) {
    for (const provider of this.providers) {
      const result = provider.resolve(params);
      if (result.isMatch) {
        return {
          ...result.context,
          profileId: provider.profileId
        };
      }
    }
    return this.defaultContext;
  }
}
exports.ProfileService = ProfileService;
class AsyncProfileService extends BaseProfileService {
  async resolve(params) {
    for (const provider of this.providers) {
      const result = await provider.resolve(params);
      if (result.isMatch) {
        return {
          ...result.context,
          profileId: provider.profileId
        };
      }
    }
    return this.defaultContext;
  }
}
exports.AsyncProfileService = AsyncProfileService;