"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProfileProviders = exports.registerEnabledProfileProviders = void 0;
var _lodash = require("lodash");
var _example_data_source_profile = require("./example_data_source_profile");
var _example_document_profile = require("./example_document_profile");
var _example_root_pofile = require("./example_root_pofile");
var _logs_data_source_profile = require("./logs_data_source_profile");
var _log_document_profile = require("./log_document_profile");
var _profile_provider_services = require("./profile_provider_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerProfileProviders = ({
  rootProfileService,
  dataSourceProfileService,
  documentProfileService,
  experimentalProfileIds
}) => {
  const providerServices = (0, _profile_provider_services.createProfileProviderServices)();
  const logsDataSourceProfileProvider = (0, _logs_data_source_profile.createLogsDataSourceProfileProvider)(providerServices);
  const logsDocumentProfileProvider = (0, _log_document_profile.createLogDocumentProfileProvider)(providerServices);
  const rootProfileProviders = [_example_root_pofile.exampleRootProfileProvider];
  const dataSourceProfileProviders = [_example_data_source_profile.exampleDataSourceProfileProvider, logsDataSourceProfileProvider];
  const documentProfileProviders = [_example_document_profile.exampleDocumentProfileProvider, logsDocumentProfileProvider];
  const enabledProfileIds = (0, _lodash.uniq)([logsDataSourceProfileProvider.profileId, logsDocumentProfileProvider.profileId, ...experimentalProfileIds]);
  registerEnabledProfileProviders({
    profileService: rootProfileService,
    availableProviders: rootProfileProviders,
    enabledProfileIds
  });
  registerEnabledProfileProviders({
    profileService: dataSourceProfileService,
    availableProviders: dataSourceProfileProviders,
    enabledProfileIds
  });
  registerEnabledProfileProviders({
    profileService: documentProfileService,
    availableProviders: documentProfileProviders,
    enabledProfileIds
  });
};
exports.registerProfileProviders = registerProfileProviders;
const registerEnabledProfileProviders = ({
  profileService,
  availableProviders,
  enabledProfileIds
}) => {
  for (const profile of availableProviders) {
    if (enabledProfileIds.includes(profile.profileId)) {
      profileService.registerProvider(profile);
    }
  }
};
exports.registerEnabledProfileProviders = registerEnabledProfileProviders;