"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogsDataSourceProfileProvider = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _data_sources = require("../../../../common/data_sources");
var _profiles = require("../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createLogsDataSourceProfileProvider = services => ({
  profileId: 'logs-data-source-profile',
  profile: {},
  resolve: params => {
    const indexPattern = extractIndexPatternFrom(params);
    if (!services.logsContextService.isLogsIndexPattern(indexPattern)) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs
      }
    };
  }
});
exports.createLogsDataSourceProfileProvider = createLogsDataSourceProfileProvider;
const extractIndexPatternFrom = ({
  dataSource,
  dataView,
  query
}) => {
  if ((0, _data_sources.isEsqlSource)(dataSource) && (0, _esQuery.isOfAggregateQueryType)(query)) {
    return (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  } else if ((0, _data_sources.isDataViewSource)(dataSource) && dataView) {
    return dataView.getIndexPattern();
  }
  return null;
};