"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleRootProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _profiles = require("../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const exampleRootProfileProvider = exports.exampleRootProfileProvider = {
  profileId: 'example-root-profile',
  profile: {
    getCellRenderers: prev => () => ({
      ...prev(),
      '@timestamp': props => {
        const timestamp = getFieldValue(props.row, '@timestamp');
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          title: timestamp,
          "data-test-subj": "exampleRootProfileTimestamp"
        }, timestamp);
      }
    })
  },
  resolve: params => {
    if (params.solutionNavId != null) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        solutionType: _profiles.SolutionType.Default
      }
    };
  }
};
const getFieldValue = (record, field) => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value[0] : value;
};