"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleDocumentProfileProvider = void 0;
var _profiles = require("../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const exampleDocumentProfileProvider = exports.exampleDocumentProfileProvider = {
  profileId: 'example-document-profile',
  profile: {},
  resolve: params => {
    if (getFieldValue(params.record, 'data_stream.type') !== 'logs') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        type: _profiles.DocumentType.Log
      }
    };
  }
};
const getFieldValue = (record, field) => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value[0] : value;
};