"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleDataSourceProfileProvider = void 0;
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _data_sources = require("../../../../common/data_sources");
var _profiles = require("../../profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const exampleDataSourceProfileProvider = exports.exampleDataSourceProfileProvider = {
  profileId: 'example-data-source-profile',
  profile: {
    getCellRenderers: prev => () => ({
      ...prev(),
      'log.level': props => {
        const level = getFieldValue(props.row, 'log.level');
        if (!level) {
          return /*#__PURE__*/_react.default.createElement("span", {
            css: {
              color: _uiTheme.euiThemeVars.euiTextSubduedColor
            },
            "data-test-subj": "exampleDataSourceProfileLogLevelEmpty"
          }, "(None)");
        }
        const levelMap = {
          info: 'primary',
          debug: 'default',
          error: 'danger'
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: levelMap[level],
          title: level,
          "data-test-subj": "exampleDataSourceProfileLogLevel"
        }, (0, _lodash.capitalize)(level));
      }
    }),
    getDocViewer: prev => params => {
      const recordId = params.record.id;
      const prevValue = prev(params);
      return {
        title: `Record #${recordId}`,
        docViewsRegistry: registry => {
          registry.enableById('doc_view_logs_overview');
          return prevValue.docViewsRegistry(registry);
        }
      };
    }
  },
  resolve: params => {
    let indexPattern;
    if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.Esql)) {
      if (!(0, _esQuery.isOfAggregateQueryType)(params.query)) {
        return {
          isMatch: false
        };
      }
      indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(params.query.esql);
    } else if ((0, _data_sources.isDataSourceType)(params.dataSource, _data_sources.DataSourceType.DataView) && params.dataView) {
      indexPattern = params.dataView.getIndexPattern();
    }
    if (indexPattern !== 'my-example-logs') {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs
      }
    };
  }
};
const getFieldValue = (record, field) => {
  const value = record.flattened[field];
  return Array.isArray(value) ? value[0] : value;
};