"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootProfile = void 0;
var _react = require("react");
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useRootProfile = ({
  solutionNavId
}) => {
  const {
    profilesManager
  } = (0, _use_discover_services.useDiscoverServices)();
  const [rootProfileLoading, setRootProfileLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    let aborted = false;
    setRootProfileLoading(true);
    profilesManager.resolveRootProfile({
      solutionNavId
    }).then(() => {
      if (!aborted) {
        setRootProfileLoading(false);
      }
    });
    return () => {
      aborted = true;
    };
  }, [profilesManager, solutionNavId]);
  return {
    rootProfileLoading
  };
};
exports.useRootProfile = useRootProfile;