"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentViewModeToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _constants = require("../../../common/constants");
var _use_discover_services = require("../../hooks/use_discover_services");
var _hits_counter = require("../hits_counter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocumentViewModeToggle = ({
  viewMode,
  isEsqlMode,
  prepend,
  stateContainer,
  setDiscoverViewMode,
  patternCount,
  dataView
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings,
    dataVisualizer: dataVisualizerService,
    aiops: aiopsService
  } = (0, _use_discover_services.useDiscoverServices)();
  const isLegacy = (0, _react.useMemo)(() => (0, _discoverUtils.isLegacyTableEnabled)({
    uiSettings,
    isEsqlMode
  }), [uiSettings, isEsqlMode]);
  const [showPatternAnalysisTab, setShowPatternAnalysisTab] = (0, _react.useState)(null);
  const showFieldStatisticsTab = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS) && dataVisualizerService !== undefined, [dataVisualizerService, uiSettings]);
  const isMounted = (0, _useMountedState.default)();
  const setShowPatternAnalysisTabWrapper = (0, _react.useCallback)(value => {
    if (isMounted()) {
      setShowPatternAnalysisTab(value);
    }
  }, [isMounted]);
  (0, _react.useEffect)(function checkForPatternAnalysis() {
    if (!aiopsService || isEsqlMode) {
      setShowPatternAnalysisTab(false);
      return;
    }
    aiopsService.getPatternAnalysisAvailable().then(patternAnalysisAvailable => {
      patternAnalysisAvailable(dataView).then(setShowPatternAnalysisTabWrapper).catch(() => setShowPatternAnalysisTabWrapper(false));
    }).catch(() => setShowPatternAnalysisTabWrapper(false));
  }, [aiopsService, dataView, isEsqlMode, setShowPatternAnalysisTabWrapper]);
  (0, _react.useEffect)(() => {
    if (showPatternAnalysisTab === false && viewMode === _constants.VIEW_MODE.PATTERN_LEVEL) {
      // switch to document view if no text fields are available
      setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL);
    }
  }, [showPatternAnalysisTab, viewMode, setDiscoverViewMode]);
  const includesNormalTabsStyle = viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL || viewMode === _constants.VIEW_MODE.PATTERN_LEVEL || isLegacy;
  const containerPadding = includesNormalTabsStyle ? euiTheme.size.s : 0;
  const containerCss = (0, _react2.css)`
    padding: ${containerPadding} ${containerPadding} 0 ${containerPadding};
  `;
  const tabsCss = (0, _react2.css)`
    .euiTab__content {
      line-height: ${euiTheme.size.xl};
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    css: containerCss
  }, prepend && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            &:empty {
              display: none;
            }
          `
  }, prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showFieldStatisticsTab === false && showPatternAnalysisTab === false ? /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.standalone,
    stateContainer: stateContainer
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: tabsCss,
    "data-test-subj": "dscViewModeToggle",
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    "data-test-subj": "dscViewModeDocumentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.document.label",
    defaultMessage: "Documents"
  }), /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    mode: _hits_counter.HitsCounterMode.appended,
    stateContainer: stateContainer
  })), showPatternAnalysisTab ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.PATTERN_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.PATTERN_LEVEL),
    "data-test-subj": "dscViewModePatternAnalysisButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.patternAnalysis.label",
    defaultMessage: "Patterns {patternCount}",
    values: {
      patternCount: patternCount !== undefined ? ` (${patternCount})` : ''
    }
  })) : null, showFieldStatisticsTab ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.AGGREGATED_LEVEL),
    "data-test-subj": "dscViewModeFieldStatsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.fieldStatistics.label",
    defaultMessage: "Field statistics"
  })) : null)));
};
exports.DocumentViewModeToggle = DocumentViewModeToggle;