"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatTopLevelObject = exports.formatRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
require("./row_formatter.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TemplateComponent = ({
  defPairs
}) => {
  return /*#__PURE__*/_react.default.createElement("dl", {
    className: 'source dscTruncateByHeight'
  }, defPairs.map((pair, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: idx
  }, /*#__PURE__*/_react.default.createElement("dt", null, pair[0], !!pair[1] && ':'), /*#__PURE__*/_react.default.createElement("dd", {
    className: "rowFormatter__value"
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: pair[1]
    }
  }), ' ')));
};
const formatRow = (hit, dataView, shouldShowFieldHandler, maxEntries, fieldFormats) => {
  const pairs = (0, _discoverUtils.formatHit)(hit, dataView, shouldShowFieldHandler, maxEntries, fieldFormats);
  return /*#__PURE__*/_react.default.createElement(TemplateComponent, {
    defPairs: pairs
  });
};
exports.formatRow = formatRow;
const formatTopLevelObject = (row, fields, dataView, maxEntries) => {
  var _row$highlight;
  const highlights = (_row$highlight = row.highlight) !== null && _row$highlight !== void 0 ? _row$highlight : {};
  const highlightPairs = [];
  const sourcePairs = [];
  const sorted = Object.entries(fields).sort(([keyA], [keyB]) => keyA.localeCompare(keyB));
  sorted.forEach(([key, values]) => {
    var _fields$getByName;
    const field = dataView.getFieldByName(key);
    const displayKey = fields.getByName ? (_fields$getByName = fields.getByName(key)) === null || _fields$getByName === void 0 ? void 0 : _fields$getByName.displayName : undefined;
    const formatter = field ? dataView.getFormatterForField(field) : {
      convert: (v, ..._) => String(v)
    };
    if (!values.map) return;
    const formatted = values.map(val => formatter.convert(val, 'html', {
      field,
      hit: row
    })).join(', ');
    const pairs = highlights[key] ? highlightPairs : sourcePairs;
    pairs.push([displayKey ? displayKey : key, formatted, key]);
  });
  return /*#__PURE__*/_react.default.createElement(TemplateComponent, {
    defPairs: [...highlightPairs, ...sourcePairs].slice(0, maxEntries)
  });
};
exports.formatTopLevelObject = formatTopLevelObject;